/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.enterprise.newBean;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.NewLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.ExplicitConstructor;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.ExplicitConstructorSessionBean;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.Fox;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.FoxLocal;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.InitializerSimpleBean;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.InitializerSimpleBeanLocal;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.Litter;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.NewEnterpriseBeanTest;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.Tame;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class NewEnterpriseBeanICTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(NewEnterpriseBeanICTest.class)).withExcludedClass(NewEnterpriseBeanTest.class.getName())).build();
    }

    @Test(groups={"integration", "new"})
    @SpecAssertion(section="3.14", id="l")
    public void testNewBeanHasSameConstructor() {
        ExplicitConstructor newBean = this.getInstanceByType(ExplicitConstructor.class, new Annotation[]{new NewLiteral(ExplicitConstructorSessionBean.class)});
        assert (newBean.getConstructorCalls() == 1);
        assert (newBean.getInjectedSimpleBean() != null);
    }

    @Test(groups={"integration", "new"})
    @SpecAssertion(section="3.14", id="m")
    public void testNewBeanHasSameInitializers() {
        InitializerSimpleBeanLocal bean = this.getInstanceByType(InitializerSimpleBeanLocal.class, new Annotation[0]);
        InitializerSimpleBeanLocal newBean = this.getInstanceByType(InitializerSimpleBeanLocal.class, new Annotation[]{new NewLiteral(InitializerSimpleBean.class)});
        assert (bean != newBean);
        assert (bean.getInitializerCalls() == 2);
    }

    @Test(groups={"integration", "new"})
    @SpecAssertion(section="3.14", id="v")
    public void testNewBeanHasNoProducerMethods() throws Exception {
        FoxLocal fox = this.getInstanceByType(FoxLocal.class, new Annotation[0]);
        FoxLocal newFox = this.getInstanceByType(FoxLocal.class, new Annotation[]{new NewLiteral(Fox.class)});
        fox.setNextLitterSize(3);
        newFox.setNextLitterSize(5);
        Litter theOnlyLitter = this.getInstanceByType(Litter.class, new Annotation[]{new AnnotationLiteral<Tame>(){}});
        assert (theOnlyLitter.getQuantity() == fox.getNextLitterSize());
    }

    @Test(groups={"integration", "new", "disposal"})
    @SpecAssertion(section="3.14", id="x")
    public void testNewBeanHasNoDisposalMethods() throws Exception {
        FoxLocal fox = this.getInstanceByType(FoxLocal.class, new Annotation[0]);
        FoxLocal newFox = this.getInstanceByType(FoxLocal.class, new Annotation[]{new NewLiteral(Fox.class)});
        Set<Bean<Litter>> beans = this.getBeans(Litter.class, new Annotation[]{new AnnotationLiteral<Tame>(){}});
        assert (beans.size() == 1);
        Bean<Litter> litterBean = beans.iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(litterBean);
        Litter litter = (Litter)litterBean.create(creationalContext);
        litterBean.destroy((Object)litter, creationalContext);
        assert (fox.isLitterDisposed());
        assert (!newFox.isLitterDisposed());
    }
}

