/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.enterprise.newBean;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.New;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.AnyLiteral;
import org.jboss.cdi.tck.literals.DefaultLiteral;
import org.jboss.cdi.tck.literals.NewLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.InitializerSimpleBean;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.InitializerSimpleBeanLocal;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.Lion;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.LionLocal;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.Monkey;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.MonkeyLocal;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.Order;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.OrderLocal;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.Tame;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.WrappedEnterpriseBean;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.WrappedEnterpriseBeanLocal;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class NewEnterpriseBeanTest
extends AbstractTest {
    private static final Annotation TAME_LITERAL = new AnnotationLiteral<Tame>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(NewEnterpriseBeanTest.class)).build();
    }

    @Test(groups={"integration", "new"})
    @SpecAssertion(section="3.14", id="p")
    public void testNewBeanIsDependentScoped() {
        Set<Bean<WrappedEnterpriseBeanLocal>> beans = this.getBeans(WrappedEnterpriseBeanLocal.class, new Annotation[]{new NewLiteral(WrappedEnterpriseBean.class)});
        assert (beans.size() == 1);
        Bean<WrappedEnterpriseBeanLocal> newEnterpriseBean = beans.iterator().next();
        assert (Dependent.class.equals((Object)newEnterpriseBean.getScope()));
    }

    @Test(groups={"integration", "new"})
    @SpecAssertion(section="3.14", id="r")
    public void testNewBeanIsHasOnlyNewBinding() {
        Set<Bean<WrappedEnterpriseBeanLocal>> beans = this.getBeans(WrappedEnterpriseBeanLocal.class, new Annotation[]{new NewLiteral(WrappedEnterpriseBean.class)});
        assert (beans.size() == 1);
        Bean<WrappedEnterpriseBeanLocal> newEnterpriseBean = beans.iterator().next();
        assert (newEnterpriseBean.getQualifiers().size() == 1);
        assert (((Annotation)newEnterpriseBean.getQualifiers().iterator().next()).annotationType().equals(New.class));
    }

    @Test(groups={"integration", "new"})
    @SpecAssertion(section="3.14", id="s")
    public void testNewBeanHasNoBeanELName() {
        Set<Bean<WrappedEnterpriseBeanLocal>> beans = this.getBeans(WrappedEnterpriseBeanLocal.class, new Annotation[]{new NewLiteral(WrappedEnterpriseBean.class)});
        assert (beans.size() == 1);
        Bean<WrappedEnterpriseBeanLocal> newEnterpriseBean = beans.iterator().next();
        assert (newEnterpriseBean.getName() == null);
    }

    @Test(groups={"integration", "new"})
    @SpecAssertion(section="3.14", id="t")
    public void testNewBeanHasNoStereotypes() {
        Bean<MonkeyLocal> monkeyBean = this.getBeans(MonkeyLocal.class, new Annotation[0]).iterator().next();
        Bean<MonkeyLocal> newMonkeyBean = this.getBeans(MonkeyLocal.class, new Annotation[]{new NewLiteral(Monkey.class)}).iterator().next();
        assert (monkeyBean.getScope().equals(RequestScoped.class));
        assert (newMonkeyBean.getScope().equals(Dependent.class));
        assert (monkeyBean.getName().equals("monkey"));
        assert (newMonkeyBean.getName() == null);
    }

    @Test(groups={"integration", "new"})
    @SpecAssertion(section="3.14", id="u")
    public void testNewBeanHasNoObservers() {
        assert (this.getCurrentManager().resolveObserverMethods((Object)"event", new Annotation[0]).size() == 1);
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="3.14", id="j"), @SpecAssertion(section="3.14", id="k")})
    public void testForEachEnterpriseBeanANewBeanExists() {
        Bean<OrderLocal> orderBean = this.getBeans(OrderLocal.class, new Annotation[0]).iterator().next();
        Set<Bean<OrderLocal>> newOrderBeans = this.getBeans(OrderLocal.class, new Annotation[]{new NewLiteral(Order.class)});
        assert (newOrderBeans.size() == 1);
        Bean<OrderLocal> newOrderBean = newOrderBeans.iterator().next();
        assert (orderBean.getQualifiers().size() == 2);
        assert (orderBean.getQualifiers().contains((Object)new DefaultLiteral()));
        assert (orderBean.getQualifiers().contains(AnyLiteral.INSTANCE));
        assert (((Object)orderBean.getTypes()).equals(newOrderBean.getTypes()));
        assert (orderBean.getBeanClass().equals(newOrderBean.getBeanClass()));
        assert (newOrderBean.getQualifiers().size() == 1);
        assert (((Annotation)newOrderBean.getQualifiers().iterator().next()).annotationType().equals(New.class));
        Set<Bean<LionLocal>> lionBeans = this.getBeans(LionLocal.class, TAME_LITERAL);
        Set<Bean<LionLocal>> newLionBeans = this.getBeans(LionLocal.class, new Annotation[]{new NewLiteral(Lion.class)});
        assert (lionBeans.size() == 1);
        assert (newLionBeans.size() == 1);
        Bean<LionLocal> lionBean = lionBeans.iterator().next();
        Bean<LionLocal> newLionBean = newLionBeans.iterator().next();
        assert (lionBean.getQualifiers().size() == 2);
        assert (lionBean.getQualifiers().contains(TAME_LITERAL));
        assert (lionBean.getQualifiers().contains(AnyLiteral.INSTANCE));
        assert (newLionBean.getQualifiers().size() == 1);
        assert (((Annotation)newLionBean.getQualifiers().iterator().next()).annotationType().equals(New.class));
        assert (((Object)lionBean.getTypes()).equals(newLionBean.getTypes()));
        assert (lionBean.getBeanClass().equals(newLionBean.getBeanClass()));
    }

    @Test(groups={"integration", "new"})
    @SpecAssertion(section="3.14", id="h")
    public void testNewBeanHasSameInjectedFields() {
        Bean<InitializerSimpleBeanLocal> simpleBean = this.getBeans(InitializerSimpleBeanLocal.class, new Annotation[0]).iterator().next();
        Bean<InitializerSimpleBeanLocal> newSimpleBean = this.getBeans(InitializerSimpleBeanLocal.class, new Annotation[]{new NewLiteral(InitializerSimpleBean.class)}).iterator().next();
        assert (!newSimpleBean.getInjectionPoints().isEmpty());
        assert (((Object)simpleBean.getInjectionPoints()).equals(newSimpleBean.getInjectionPoints()));
    }
}

