/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.IllegalProductException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.BlackWidow;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.BlackWidowConsumer;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.BlackWidowProducer;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.Broken;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.BrownRecluse;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.DefangedTarantula;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.Null;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.NullSpiderConsumer;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.NullSpiderConsumerForBrokenProducer;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.StaticTarantulaConsumer;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.StaticTarantulaProducer;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.Tame;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.TarantulaConsumer;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class ProducerFieldLifecycleTest
extends AbstractTest {
    private AnnotationLiteral<Null> NULL_LITERAL = new AnnotationLiteral<Null>(){};
    private AnnotationLiteral<Broken> BROKEN_LITERAL = new AnnotationLiteral<Broken>(){};
    private AnnotationLiteral<Tame> TAME_LITERAL = new AnnotationLiteral<Tame>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ProducerFieldLifecycleTest.class)).build();
    }

    @Test(groups={"producerField"})
    @SpecAssertions(value={@SpecAssertion(section="3.4", id="aa")})
    public void testProducerFieldNotAnotherBean() {
        assert (this.getInstanceByType(BrownRecluse.class, new Annotation[0]) != null);
    }

    @Test(groups={"producerField"})
    @SpecAssertions(value={@SpecAssertion(section="5.5.5", id="a"), @SpecAssertion(section="3.4", id="b")})
    public void testProducerStaticFieldBean() {
        StaticTarantulaConsumer tarantulaConsumer = this.getInstanceByType(StaticTarantulaConsumer.class, new Annotation[0]);
        assert (tarantulaConsumer.getConsumedTarantula().equals(StaticTarantulaProducer.produceTarantula));
    }

    @Test(groups={"producerField"})
    @SpecAssertions(value={@SpecAssertion(section="5.5.5", id="b"), @SpecAssertion(section="7.3.5", id="ga")})
    public void testProducerFieldBeanCreate() throws Exception {
        BlackWidowConsumer spiderConsumer = this.getInstanceByType(BlackWidowConsumer.class, new Annotation[0]);
        assert (spiderConsumer.getInjectedSpider().equals(BlackWidowProducer.blackWidow));
    }

    @Test(groups={"producerField", "specialization"})
    @SpecAssertions(value={@SpecAssertion(section="4.3", id="cd")})
    public void testProducerFieldFromSpecializingBeanUsed() throws Exception {
        TarantulaConsumer spiderConsumer = this.getInstanceByType(TarantulaConsumer.class, new Annotation[0]);
        assert (spiderConsumer.getConsumedTarantula() != null);
        assert (spiderConsumer.getConsumedTarantula() instanceof DefangedTarantula);
    }

    @Test(groups={"producerField"})
    @SpecAssertions(value={@SpecAssertion(section="3.4", id="d"), @SpecAssertion(section="7.3.5", id="m")})
    public void testProducerFieldReturnsNullIsDependent() throws Exception {
        NullSpiderConsumer consumerBean = this.getInstanceByType(NullSpiderConsumer.class, new Annotation[0]);
        assert (consumerBean.getInjectedSpider() == null);
    }

    @Test(groups={"producerField"}, expectedExceptions={IllegalProductException.class})
    @SpecAssertions(value={@SpecAssertion(section="7.3.5", id="n")})
    public void testProducerFieldForNullValueNotDependent() throws Exception {
        Bean<BlackWidow> spiderBean = this.getBeans(BlackWidow.class, new Annotation[]{this.NULL_LITERAL, this.BROKEN_LITERAL}).iterator().next();
        CreationalContext spiderContext = this.getCurrentManager().createCreationalContext(spiderBean);
        spiderBean.create(spiderContext);
        assert (false);
    }

    @Test(groups={"producerField"}, expectedExceptions={IllegalProductException.class})
    @SpecAssertions(value={@SpecAssertion(section="3.4", id="e"), @SpecAssertion(section="7.3.5", id="n")})
    public void testProducerFieldReturnsNullIsNotDependent() throws Exception {
        NullSpiderConsumerForBrokenProducer consumer = this.getInstanceByType(NullSpiderConsumerForBrokenProducer.class, new Annotation[0]);
        if (consumer.getInjectedSpider() != null) {
            consumer.getInjectedSpider().bite();
        }
    }

    @Test(groups={"producerField"})
    @SpecAssertions(value={@SpecAssertion(section="7.3.5", id="o")})
    public void testProducerFieldBeanDestroy() throws Exception {
        BlackWidowProducer.reset();
        Bean<BlackWidow> bean = this.getUniqueBean(BlackWidow.class, new Annotation[]{this.TAME_LITERAL});
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        BlackWidow instance = (BlackWidow)bean.create(ctx);
        bean.destroy((Object)instance, ctx);
        Assert.assertTrue((boolean)BlackWidowProducer.blackWidowDestroyed);
        Assert.assertEquals((long)BlackWidowProducer.destroyedBlackWidowTimeOfBirth, (long)instance.getTimeOfBirth());
    }
}

