/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import javax.enterprise.util.TypeLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.AnyLiteral;
import org.jboss.cdi.tck.literals.DefaultLiteral;
import org.jboss.cdi.tck.literals.NewLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Bestiary;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Consumer;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Den;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Dragon;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.ExplicitContructorSimpleBean;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Fox;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.FoxRun;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Griffin;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Hippogriff;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.InitializerSimpleBean;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Lion;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.LionCage;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Litter;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.NewLionConsumer;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Order;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Shop;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Tame;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Tiger;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class NewSimpleBeanTest
extends AbstractTest {
    private static final Annotation TAME_LITERAL = new AnnotationLiteral<Tame>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(NewSimpleBeanTest.class)).withBeansXml("beans.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.14", id="ya")})
    public void testNewBeanCreatedForFieldInjectionPoint() {
        assert (this.getInstanceByType(Griffin.class, new Annotation[0]).getList() instanceof ArrayList);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.14", id="yc")})
    public void testNewBeanCreatedForInitializerInjectionPoint() {
        assert (this.getInstanceByType(Dragon.class, new Annotation[0]).getChildren() instanceof HashSet);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.14", id="ye")})
    public void testNewBeanCreatedForConstructorInjectioAnPoint() {
        assert (this.getInstanceByType(Hippogriff.class, new Annotation[0]).getHomes() instanceof HashMap);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.14", id="yg")})
    public void testNewBeanCreatedForProducerMethod() {
        assert (this.getInstanceByType(new TypeLiteral<Collection<Dragon>>(){}, new Annotation[0]) instanceof ArrayList);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.14", id="yi")})
    public void testNewBeanCreatedForObserverMethod() {
        this.getCurrentManager().fireEvent((Object)new Griffin(), new Annotation[0]);
        assert (this.getInstanceByType(Bestiary.class, new Annotation[0]).getPossibleNames() instanceof TreeSet);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.14", id="yk")})
    public void testNewBeanCreatedForDisposerMethod() {
        Bean<Collection<Dragon>> bean = this.getUniqueBean(new TypeLiteral<Collection<Dragon>>(){}, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        Collection dragons = (Collection)bean.create(ctx);
        bean.destroy((Object)dragons, ctx);
        assert (this.getInstanceByType(Bestiary.class, new Annotation[0]).getKnightsWhichKilledTheDragons() instanceof LinkedHashSet);
    }

    @Test(groups={"new"})
    @SpecAssertions(value={})
    public void testNewBeanIsDependentScoped() {
        FoxRun foxRun = this.getInstanceByType(FoxRun.class, new Annotation[0]);
        foxRun.getNewFox().setDen(new Den("TheLarches"));
        assert (!foxRun.getNewFox().getDen().getName().equals(foxRun.getNewFox2().getDen().getName()));
    }

    @Test(groups={"new"})
    @SpecAssertion(section="3.14", id="t")
    public void testNewBeanHasNoStereotypes() {
        Bean<Fox> foxBean = this.getBeans(Fox.class, new Annotation[0]).iterator().next();
        assert (foxBean.getScope().equals(RequestScoped.class));
        assert (foxBean.getName().equals("fox"));
        Fox newFox1 = this.getInstanceByType(FoxRun.class, new Annotation[0]).getNewFox();
        Fox newFox2 = this.getInstanceByType(FoxRun.class, new Annotation[0]).getNewFox();
        newFox1.setDen(new Den("TheElms"));
        assert (newFox2.getDen().getName() != "TheElms");
    }

    @Test(groups={"new"})
    @SpecAssertion(section="3.14", id="u")
    public void testNewBeanHasNoObservers() {
        assert (this.getCurrentManager().resolveObserverMethods((Object)"event", new Annotation[0]).size() == 1);
    }

    @Test(groups={"new"})
    @SpecAssertion(section="3.14", id="w")
    public void testNewBeanHasNoProducerFields() throws Exception {
        FoxRun foxRun = this.getInstanceByType(FoxRun.class, new Annotation[0]);
        foxRun.getNewFox().setDen(new Den("NewFoxDen"));
        Den theOnlyDen = this.getInstanceByType(Den.class, new Annotation[0]);
        assert (theOnlyDen.getName().equals(foxRun.getFox().getDen().getName()));
    }

    @Test(groups={"new"})
    @SpecAssertion(section="3.14", id="v")
    public void testNewBeanHasNoProducerMethods() throws Exception {
        FoxRun foxRun = this.getInstanceByType(FoxRun.class, new Annotation[0]);
        foxRun.getFox().setNextLitterSize(3);
        foxRun.getNewFox().setNextLitterSize(5);
        Litter theOnlyLitter = this.getInstanceByType(Litter.class, new Annotation[0]);
        assert (theOnlyLitter.getQuantity() == foxRun.getFox().getNextLitterSize());
    }

    @Test(groups={"new"})
    @SpecAssertion(section="3.14", id="x")
    public void testNewBeanHasNoDisposerMethods() throws Exception {
        FoxRun foxRun = this.getInstanceByType(FoxRun.class, new Annotation[0]);
        Bean<Litter> litterBean = this.getBeans(Litter.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(litterBean);
        Litter litter = this.getInstanceByType(Litter.class, new Annotation[0]);
        litterBean.destroy((Object)litter, creationalContext);
        assert (foxRun.getFox().isLitterDisposed());
        assert (!foxRun.getNewFox().isLitterDisposed());
    }

    @Test
    @SpecAssertion(section="3.14", id="d")
    public void testForEachSimpleBeanANewBeanExists() {
        assert (this.getBeans(Order.class, new Annotation[0]).size() == 1);
        assert (this.getUniqueBean(Order.class, new Annotation[0]).getQualifiers().size() == 2);
        assert (this.getUniqueBean(Order.class, new Annotation[0]).getQualifiers().contains((Object)new DefaultLiteral()));
        assert (this.getInstanceByType(Shop.class, new Annotation[0]).getNewOrder() != null);
        assert (this.getCurrentManager().getBeans(Lion.class, new Annotation[]{TAME_LITERAL}).size() == 1);
        assert (((Bean)this.getCurrentManager().getBeans(Lion.class, new Annotation[]{TAME_LITERAL}).iterator().next()).getQualifiers().size() == 2);
        assert (((Bean)this.getCurrentManager().getBeans(Lion.class, new Annotation[]{TAME_LITERAL}).iterator().next()).getQualifiers().contains(TAME_LITERAL));
        assert (((Bean)this.getCurrentManager().getBeans(Lion.class, new Annotation[]{TAME_LITERAL}).iterator().next()).getQualifiers().contains(AnyLiteral.INSTANCE));
        assert (this.getInstanceByType(LionCage.class, new Annotation[0]).getNewLion() != null);
    }

    @Test(groups={"new"})
    @SpecAssertion(section="3.14", id="f")
    public void testNewBeanHasSameConstructor() {
        ExplicitContructorSimpleBean.setConstructorCalls(0);
        Consumer consumer = this.getInstanceByType(Consumer.class, new Annotation[0]);
        consumer.getExplicitConstructorBean().ping();
        consumer.getNewExplicitConstructorBean().ping();
        int calls = ExplicitContructorSimpleBean.getConstructorCalls();
        assert (calls == 2);
    }

    @Test(groups={"new"})
    @SpecAssertion(section="3.14", id="g")
    public void testNewBeanHasSameInitializers() {
        InitializerSimpleBean.setInitializerCalls(0);
        Consumer consumer = this.getInstanceByType(Consumer.class, new Annotation[0]);
        consumer.getInitializerSimpleBean().businessMethod();
        consumer.getNewInitializerSimpleBean().businessMethod();
        int calls = InitializerSimpleBean.getInitializerCalls();
        assert (calls == 2);
    }

    @Test(groups={"new"})
    @SpecAssertion(section="3.14", id="h")
    public void testNewBeanHasSameInjectedFields() {
        Consumer consumer = this.getInstanceByType(Consumer.class, new Annotation[0]);
        assert (consumer.getNewInitializerSimpleBean().getOrder() != null);
    }

    @Test(groups={"new"})
    @SpecAssertion(section="3.14", id="xb")
    public void testNewBeanIsNotAlternative() {
        assert (this.getUniqueBean(Tiger.class, new Annotation[0]).isAlternative());
        assert (!this.getUniqueBean(Tiger.class, new Annotation[]{NewLiteral.INSTANCE}).isAlternative());
    }

    @Test
    @SpecAssertion(section="3.14", id="z")
    public void testNewBeanWithNoMemberValue() {
        assert (this.getInstanceByType(NewLionConsumer.class, new Annotation[0]).getLion() instanceof Lion);
    }
}

