/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.inheritance.generics;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.inheritance.generics.Baz;
import org.jboss.cdi.tck.tests.inheritance.generics.Foo;
import org.jboss.cdi.tck.tests.inheritance.generics.Qux;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class MemberLevelInheritanceTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(MemberLevelInheritanceTest.class)).build();
    }

    @Test
    @SpecAssertion(section="4.2", id="f")
    public void testInjectionPoint() throws Exception {
        Bean<Foo> fooBean = this.getUniqueBean(Foo.class, new Annotation[0]);
        Set injectionPoints = fooBean.getInjectionPoints();
        Assert.assertEquals((int)injectionPoints.size(), (int)1);
        InjectionPoint inheritedInjectionPoint = (InjectionPoint)injectionPoints.iterator().next();
        this.checkParameterizedType(inheritedInjectionPoint.getType(), (Type)((Object)Baz.class), (Type)((Object)String.class));
    }

    @Test
    @SpecAssertion(section="4.2", id="j")
    public void testObserver() throws Exception {
        Set observerMethods = this.getCurrentManager().resolveObserverMethods((Object)new Qux(null), new Annotation[0]);
        Assert.assertEquals((int)observerMethods.size(), (int)2);
        for (ObserverMethod observerMethod : observerMethods) {
            if (!observerMethod.getBeanClass().equals(Foo.class)) continue;
            this.checkParameterizedType(observerMethod.getObservedType(), (Type)((Object)Baz.class), (Type)((Object)String.class));
            return;
        }
        Assert.fail();
    }

    private void checkParameterizedType(Type declaredType, Type rawType, Type argumentType) {
        Assert.assertTrue((boolean)(declaredType instanceof ParameterizedType));
        ParameterizedType parameterizedType = (ParameterizedType)declaredType;
        Assert.assertEquals((Object)parameterizedType.getRawType(), (Object)rawType);
        Type[] arguments = parameterizedType.getActualTypeArguments();
        Assert.assertEquals((int)arguments.length, (int)1);
        Assert.assertTrue((boolean)arguments[0].equals(argumentType));
    }
}

