/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.interceptors.definition;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.interceptors.definition.Atomic;
import org.jboss.cdi.tck.tests.interceptors.definition.AtomicFoo;
import org.jboss.cdi.tck.tests.interceptors.definition.AtomicInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.FileLogger;
import org.jboss.cdi.tck.tests.interceptors.definition.Logged;
import org.jboss.cdi.tck.tests.interceptors.definition.MissileBinding;
import org.jboss.cdi.tck.tests.interceptors.definition.MissileInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.NetworkLogger;
import org.jboss.cdi.tck.tests.interceptors.definition.NonBindingType;
import org.jboss.cdi.tck.tests.interceptors.definition.NotEnabledAtomicInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.Secure;
import org.jboss.cdi.tck.tests.interceptors.definition.SecureInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.SecureTransaction;
import org.jboss.cdi.tck.tests.interceptors.definition.Transactional;
import org.jboss.cdi.tck.tests.interceptors.definition.TransactionalInterceptor;
import org.jboss.cdi.tck.util.HierarchyDiscovery;
import org.jboss.cdi.tck.util.ParameterizedTypeImpl;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class InterceptorDefinitionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InterceptorDefinitionTest.class)).withClasses(HierarchyDiscovery.class, ParameterizedTypeImpl.class)).withBeansXml("beans.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.1.2", id="a")})
    public void testInterceptorsImplementInterceptorInterface() {
        boolean interfaceFound = false;
        for (Type type : this.getInterfacesImplemented(this.getTransactionalInterceptor().getClass())) {
            if (!(type instanceof ParameterizedTypeImpl) || !((ParameterizedTypeImpl)type).getRawType().equals(Interceptor.class)) continue;
            interfaceFound = true;
            break;
        }
        assert (interfaceFound);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.1.2", id="b")})
    public void testInterceptorBindingTypes() {
        Interceptor<?> interceptorBean = this.getTransactionalInterceptor();
        assert (interceptorBean.getInterceptorBindings().size() == 1);
        assert (interceptorBean.getInterceptorBindings().contains(new AnnotationLiteral<Transactional>(){}));
    }

    @Test(groups={"rewrite"})
    @SpecAssertions(value={@SpecAssertion(section="11.1.2", id="c"), @SpecAssertion(section="11.1.2", id="e")})
    public void testInterceptionType() {
        Interceptor<?> interceptorBean = this.getTransactionalInterceptor();
        assert (interceptorBean.intercepts(InterceptionType.AROUND_INVOKE));
        assert (!interceptorBean.intercepts(InterceptionType.POST_ACTIVATE));
        assert (!interceptorBean.intercepts(InterceptionType.POST_CONSTRUCT));
        assert (!interceptorBean.intercepts(InterceptionType.PRE_DESTROY));
        assert (!interceptorBean.intercepts(InterceptionType.PRE_PASSIVATE));
    }

    @Test
    @SpecAssertion(section="11.1.2", id="f")
    public void testInstanceOfInterceptorForEveryEnabledInterceptor() {
        List<AnnotationLiteral> annotationLiterals = Arrays.asList(new AnnotationLiteral<Transactional>(){}, new AnnotationLiteral<Secure>(){}, new AnnotationLiteral<MissileBinding>(){}, new AnnotationLiteral<Logged>(){});
        ArrayList<Class> interceptorClasses = new ArrayList<Class>(Arrays.asList(AtomicInterceptor.class, MissileInterceptor.class, SecureInterceptor.class, TransactionalInterceptor.class, NetworkLogger.class, FileLogger.class, NotEnabledAtomicInterceptor.class));
        for (AnnotationLiteral annotationLiteral : annotationLiterals) {
            List interceptors = this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{annotationLiteral});
            for (Interceptor interceptor : interceptors) {
                interceptorClasses.remove(interceptor.getBeanClass());
            }
        }
        List interceptors = this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{new AnnotationLiteral<Atomic>(){}, new AnnotationLiteral<MissileBinding>(){}});
        for (Interceptor interceptor : interceptors) {
            interceptorClasses.remove(interceptor.getBeanClass());
        }
        assert (interceptorClasses.size() == 1);
        assert (((Class)interceptorClasses.get(0)).equals(NotEnabledAtomicInterceptor.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.3.13", id="a")})
    public void testResolveInterceptorsReturnsOrderedList() {
        AnnotationLiteral<Transactional> transactionalBinding = new AnnotationLiteral<Transactional>(){};
        AnnotationLiteral<Secure> secureBinding = new AnnotationLiteral<Secure>(){};
        List interceptors = this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{transactionalBinding, secureBinding});
        assert (interceptors.size() == 2);
        assert (((Interceptor)interceptors.get(0)).getInterceptorBindings().size() == 1);
        assert (((Interceptor)interceptors.get(0)).getInterceptorBindings().contains(secureBinding));
        assert (((Interceptor)interceptors.get(1)).getInterceptorBindings().size() == 1);
        assert (((Interceptor)interceptors.get(1)).getInterceptorBindings().contains(transactionalBinding));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertions(value={@SpecAssertion(section="11.3.13", id="b")})
    public void testSameBindingTypesToResolveInterceptorsFails() {
        AnnotationLiteral<Transactional> transactionalBinding = new AnnotationLiteral<Transactional>(){};
        this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{transactionalBinding, transactionalBinding});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertions(value={@SpecAssertion(section="11.3.13", id="c")})
    public void testNoBindingTypesToResolveInterceptorsFails() {
        this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertions(value={@SpecAssertion(section="11.3.13", id="d")})
    public void testNonBindingTypeToResolveInterceptorsFails() {
        AnnotationLiteral<NonBindingType> nonBinding = new AnnotationLiteral<NonBindingType>(){};
        this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{nonBinding});
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="9.1", id="a"), @SpecAssertion(section="9.1", id="b"), @SpecAssertion(section="9.1", id="c"), @SpecAssertion(section="9.3", id="a")})
    public void testInterceptorBindingAnnotation() {
        List<Interceptor<?>> interceptors = this.getLoggedInterceptors();
        assert (interceptors.size() > 1);
        Interceptor<?> interceptorBean = interceptors.iterator().next();
        assert (interceptorBean.getInterceptorBindings().size() == 1);
        assert (interceptorBean.getInterceptorBindings().contains(new AnnotationLiteral<Logged>(){}));
        Target target = ((Annotation)interceptorBean.getInterceptorBindings().iterator().next()).annotationType().getAnnotation(Target.class);
        List<ElementType> elements = Arrays.asList(target.value());
        assert (elements.contains((Object)ElementType.TYPE));
        assert (elements.contains((Object)ElementType.METHOD));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="9.1.2", id="a"), @SpecAssertion(section="9.1.2", id="b"), @SpecAssertion(section="2.7.1.2", id="b")})
    public void testStereotypeInterceptorBindings() {
        FileLogger.intercepted = false;
        NetworkLogger.intercepted = false;
        SecureTransaction secureTransaction = this.getInstanceByType(SecureTransaction.class, new Annotation[0]);
        secureTransaction.transact();
        assert (FileLogger.intercepted);
        assert (NetworkLogger.intercepted);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="9.1.1", id="a"), @SpecAssertion(section="9.1.1", id="b")})
    public void testInterceptorBindingsCanDeclareOtherInterceptorBindings() {
        AtomicInterceptor.intercepted = false;
        MissileInterceptor.intercepted = false;
        AtomicFoo foo = this.getInstanceByType(AtomicFoo.class, new Annotation[0]);
        foo.doAction();
        assert (AtomicInterceptor.intercepted);
        assert (MissileInterceptor.intercepted);
    }

    private Interceptor<?> getTransactionalInterceptor() {
        return (Interceptor)this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{new AnnotationLiteral<Transactional>(){}}).iterator().next();
    }

    private List<Interceptor<?>> getLoggedInterceptors() {
        return this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{new AnnotationLiteral<Logged>(){}});
    }

    private Set<Type> getInterfacesImplemented(Class<?> clazz) {
        HashSet<Type> interfaces = new HashSet<Type>();
        interfaces.addAll(new HierarchyDiscovery(clazz).getFlattenedTypes());
        return interfaces;
    }
}

