/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.interceptors.invocation;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.Timer;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.interceptors.invocation.AlmightyInterceptor;
import org.jboss.cdi.tck.tests.interceptors.invocation.Missile;
import org.jboss.cdi.tck.tests.interceptors.invocation.MissileObserver;
import org.jboss.cdi.tck.tests.interceptors.invocation.Rye;
import org.jboss.cdi.tck.tests.interceptors.invocation.Timing;
import org.jboss.cdi.tck.tests.interceptors.invocation.Watcher;
import org.jboss.cdi.tck.tests.interceptors.invocation.Wheat;
import org.jboss.cdi.tck.tests.interceptors.invocation.WheatProducer;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class InterceptorInvocationTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InterceptorInvocationTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createInterceptors().clazz(new String[]{AlmightyInterceptor.class.getName()}).up())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7.2", id="a"), @SpecAssertion(section="9.2", id="a"), @SpecAssertion(section="12.4", id="kb")})
    public void testManagedBeanIsIntercepted() {
        AlmightyInterceptor.reset();
        Missile missile = this.getInstanceByType(Missile.class, new Annotation[0]);
        missile.fire();
        Assert.assertTrue((boolean)AlmightyInterceptor.methodIntercepted);
        Assert.assertNotNull((Object)missile.getWarhead());
        AlmightyInterceptor.reset();
        Watcher watcher = this.getInstanceByType(Watcher.class, new Annotation[0]);
        watcher.ping();
        Assert.assertTrue((boolean)AlmightyInterceptor.methodIntercepted);
        Assert.assertTrue((boolean)AlmightyInterceptor.lifecycleCallbackIntercepted);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7.2", id="a1"), @SpecAssertion(section="3.10", id="f")})
    public void testInitializerMethodsNotIntercepted() {
        AlmightyInterceptor.reset();
        Missile missile = this.getInstanceByType(Missile.class, new Annotation[0]);
        Assert.assertFalse((boolean)AlmightyInterceptor.methodIntercepted);
        Assert.assertTrue((boolean)missile.initCalled());
        Assert.assertTrue((boolean)AlmightyInterceptor.methodIntercepted);
    }

    @Test
    @SpecAssertion(section="7.2", id="ia")
    public void testProducerMethodsAreIntercepted() {
        AlmightyInterceptor.reset();
        this.getInstanceByType(Wheat.class, new Annotation[0]);
        Assert.assertTrue((boolean)AlmightyInterceptor.methodIntercepted);
    }

    @Test
    @SpecAssertion(section="7.2", id="ic")
    public void testDisposerMethodsAreIntercepted() {
        AlmightyInterceptor.reset();
        Bean<Wheat> bean = this.getBeans(Wheat.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(bean);
        Wheat instance = this.getInstanceByType(Wheat.class, new Annotation[0]);
        AlmightyInterceptor.methodIntercepted = false;
        bean.destroy((Object)instance, creationalContext);
        Assert.assertTrue((boolean)WheatProducer.destroyed);
        Assert.assertTrue((boolean)AlmightyInterceptor.methodIntercepted);
    }

    @Test
    @SpecAssertion(section="7.2", id="ie")
    public void testObserverMethodsAreIntercepted() {
        AlmightyInterceptor.reset();
        this.getCurrentManager().fireEvent((Object)new Missile(), new Annotation[0]);
        Assert.assertTrue((boolean)MissileObserver.observed);
        Assert.assertTrue((boolean)AlmightyInterceptor.methodIntercepted);
    }

    @Test
    @SpecAssertion(section="7.2", id="j")
    public void testLifecycleCallbacksAreIntercepted() {
        AlmightyInterceptor.reset();
        Rye rye = this.getInstanceByType(Rye.class, new Annotation[0]);
        rye.ping();
        Assert.assertTrue((boolean)AlmightyInterceptor.methodIntercepted);
        Assert.assertTrue((boolean)AlmightyInterceptor.lifecycleCallbackIntercepted);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7.2", id="m"), @SpecAssertion(section="7.2", id="g")})
    public void testObjectMethodsAreNotIntercepted() {
        AlmightyInterceptor.reset();
        this.getInstanceByType(Missile.class, new Annotation[0]).toString();
        Assert.assertFalse((boolean)AlmightyInterceptor.methodIntercepted);
        Assert.assertTrue((boolean)AlmightyInterceptor.lifecycleCallbackIntercepted);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"javaee-full"})
    @SpecAssertion(section="7.2", id="ig")
    public void testTimeoutMethodIntercepted(Timing timing) throws Exception {
        timing.createTimer();
        new Timer().addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return AlmightyInterceptor.timeoutIntercepted;
            }
        }).start();
        Assert.assertNotNull((Object)Timing.timeoutAt);
        Assert.assertTrue((boolean)AlmightyInterceptor.timeoutIntercepted);
    }
}

