/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.byname;

import java.lang.annotation.Annotation;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.byname.AlaskaPlaice;
import org.jboss.cdi.tck.tests.lookup.byname.FishingNet;
import org.jboss.cdi.tck.tests.lookup.byname.Sole;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class ResolutionByNameTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ResolutionByNameTest.class)).withBeansXml("beans.xml")).build();
    }

    @Test(groups={"resolution"})
    @SpecAssertions(value={@SpecAssertion(section="5.3.1", id="ca"), @SpecAssertion(section="11.3.6", id="aa"), @SpecAssertion(section="11.3.6", id="b")})
    public void testAmbiguousELNamesResolved() throws Exception {
        Set beans = this.getCurrentManager().getBeans("whitefish");
        assert (beans.size() == 1);
        assert (this.getCurrentManager().resolve(beans).getTypes().contains(AlaskaPlaice.class));
        beans = this.getCurrentManager().getBeans("fish");
        assert (beans.size() == 2);
        assert (this.getCurrentManager().resolve(beans).getTypes().contains(Sole.class));
    }

    @Test
    @SpecAssertion(section="3.13", id="a")
    public void testFieldNameUsedAsBeanName() {
        assert (this.getInstanceByType(FishingNet.class, new Annotation[0]).isCarpInjected());
    }
}

