/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.dynamic;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.AnyLiteral;
import org.jboss.cdi.tck.literals.DefaultLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.dynamic.AdvancedPaymentProcessor;
import org.jboss.cdi.tck.tests.lookup.dynamic.AsynchronousPaymentProcessor;
import org.jboss.cdi.tck.tests.lookup.dynamic.NonBinding;
import org.jboss.cdi.tck.tests.lookup.dynamic.ObtainsInstanceBean;
import org.jboss.cdi.tck.tests.lookup.dynamic.ObtainsNewInstanceBean;
import org.jboss.cdi.tck.tests.lookup.dynamic.PayBy;
import org.jboss.cdi.tck.tests.lookup.dynamic.PayByBinding;
import org.jboss.cdi.tck.tests.lookup.dynamic.PaymentProcessor;
import org.jboss.cdi.tck.tests.lookup.dynamic.RemotePaymentProcessor;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class DynamicLookupTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(DynamicLookupTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.6", id="aa")})
    public void testObtainsInjectsInstanceOfInstance() {
        ObtainsInstanceBean injectionPoint = this.getInstanceByType(ObtainsInstanceBean.class, new Annotation[0]);
        assert (injectionPoint.getPaymentProcessor() != null);
    }

    @Test
    @SpecAssertion(section="5.6.1", id="da")
    public void testDuplicateBindingsThrowsException() {
        try {
            ObtainsInstanceBean injectionPoint = this.getInstanceByType(ObtainsInstanceBean.class, new Annotation[0]);
            injectionPoint.getAnyPaymentProcessor().select(new Annotation[]{new DefaultLiteral(), new DefaultLiteral()});
        }
        catch (Throwable t) {
            assert (this.isThrowablePresent(IllegalArgumentException.class, t));
            return;
        }
        assert (false);
    }

    @Test
    @SpecAssertion(section="5.6.1", id="e")
    public void testNonBindingThrowsException() {
        try {
            ObtainsInstanceBean injectionPoint = this.getInstanceByType(ObtainsInstanceBean.class, new Annotation[0]);
            injectionPoint.getAnyPaymentProcessor().select(new Annotation[]{new AnnotationLiteral<NonBinding>(){}});
        }
        catch (Throwable t) {
            assert (this.isThrowablePresent(IllegalArgumentException.class, t));
            return;
        }
        assert (false);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.6", id="ba"), @SpecAssertion(section="5.6", id="ca"), @SpecAssertion(section="5.6.1", id="aa"), @SpecAssertion(section="5.6.1", id="ab"), @SpecAssertion(section="5.6.1", id="fa"), @SpecAssertion(section="5.6.1", id="fc")})
    public void testGetMethod() {
        this.getInstanceByType(AdvancedPaymentProcessor.class, new Annotation[]{AnyLiteral.INSTANCE}).setValue(10);
        Instance<AsynchronousPaymentProcessor> instance = this.getInstanceByType(ObtainsInstanceBean.class, new Annotation[0]).getPaymentProcessor();
        assert (instance.get() instanceof AdvancedPaymentProcessor);
        assert (((AsynchronousPaymentProcessor)instance.get()).getValue() == 10);
    }

    @Test
    @SpecAssertion(section="5.6.1", id="fba")
    public void testUnsatisfiedDependencyThrowsException() {
        try {
            this.getInstanceByType(ObtainsInstanceBean.class, new Annotation[0]).getPaymentProcessor().select(RemotePaymentProcessor.class, new Annotation[0]).get();
        }
        catch (Throwable t) {
            assert (this.isThrowablePresent(UnsatisfiedResolutionException.class, t));
            return;
        }
        assert (false);
    }

    @Test
    @SpecAssertion(section="5.6.1", id="fbb")
    public void testAmbiguousDependencyThrowsException() {
        try {
            this.getInstanceByType(ObtainsInstanceBean.class, new Annotation[0]).getAnyPaymentProcessor().get();
        }
        catch (Throwable t) {
            assert (this.isThrowablePresent(AmbiguousResolutionException.class, t));
            return;
        }
        assert (false);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.6.1", id="aa"), @SpecAssertion(section="5.6.1", id="ba"), @SpecAssertion(section="5.6.1", id="ja"), @SpecAssertion(section="5.6.1", id="ka"), @SpecAssertion(section="5.6.3", id="a")})
    public void testIteratorMethod() {
        this.getInstanceByType(AdvancedPaymentProcessor.class, new Annotation[]{AnyLiteral.INSTANCE}).setValue(1);
        this.getInstanceByType(RemotePaymentProcessor.class, new Annotation[]{AnyLiteral.INSTANCE}).setValue(2);
        Instance<PaymentProcessor> instance = this.getInstanceByType(ObtainsInstanceBean.class, new Annotation[0]).getAnyPaymentProcessor();
        Iterator iterator1 = instance.select(AsynchronousPaymentProcessor.class, new Annotation[0]).iterator();
        AdvancedPaymentProcessor advanced = null;
        RemotePaymentProcessor remote = null;
        int instances = 0;
        while (iterator1.hasNext()) {
            PaymentProcessor processor = (PaymentProcessor)iterator1.next();
            if (processor instanceof AdvancedPaymentProcessor) {
                advanced = (AdvancedPaymentProcessor)processor;
            } else if (processor instanceof RemotePaymentProcessor) {
                remote = (RemotePaymentProcessor)processor;
            } else {
                throw new RuntimeException("Unexpected instance returned by iterator.");
            }
            ++instances;
        }
        assert (instances == 2);
        assert (advanced != null);
        assert (advanced.getValue() == 1);
        assert (remote != null);
        assert (remote.getValue() == 2);
        Iterator iterator2 = instance.select(RemotePaymentProcessor.class, new Annotation[]{new PayByBinding(){

            @Override
            public PayBy.PaymentMethod value() {
                return PayBy.PaymentMethod.CREDIT_CARD;
            }
        }}).iterator();
        assert (((RemotePaymentProcessor)iterator2.next()).getValue() == 2);
        assert (!iterator2.hasNext());
    }

    @Test
    @SpecAssertion(section="5.6.1", id="l")
    public void testIsUnsatisfied() {
        ObtainsInstanceBean injectionPoint = this.getInstanceByType(ObtainsInstanceBean.class, new Annotation[0]);
        assert (!injectionPoint.getAnyPaymentProcessor().isUnsatisfied());
        assert (injectionPoint.getPaymentProcessor().select(RemotePaymentProcessor.class, new Annotation[0]).isUnsatisfied());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.6", id="da"), @SpecAssertion(section="5.6.1", id="m")})
    public void testIsAmbiguous() {
        ObtainsInstanceBean injectionPoint = this.getInstanceByType(ObtainsInstanceBean.class, new Annotation[0]);
        assert (injectionPoint.getAnyPaymentProcessor().isAmbiguous());
        assert (!injectionPoint.getPaymentProcessor().isAmbiguous());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.6", id="e"), @SpecAssertion(section="5.6.3", id="b")})
    public void testNewBean() {
        String instance = this.getInstanceByType(ObtainsNewInstanceBean.class, new Annotation[0]).getString();
        assert (instance != null && instance instanceof String);
        this.getInstanceByType(ObtainsNewInstanceBean.class, new Annotation[0]).getMap();
    }

    @Test
    @SpecAssertion(section="3.14", id="xc")
    public void testNewBeanNotEnabledWithouInjectionPoint() {
        assert (this.getInstanceByType(ObtainsNewInstanceBean.class, new Annotation[0]).getIae().isUnsatisfied());
    }
}

