/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.injection.enterprise;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.injection.enterprise.DeluxeHenHouseLocal;
import org.jboss.cdi.tck.tests.lookup.injection.enterprise.FarmLocal;
import org.jboss.cdi.tck.tests.lookup.injection.enterprise.InjectedSessionBeanLocal;
import org.jboss.cdi.tck.tests.lookup.injection.enterprise.MegaPoorHenHouseLocal;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class SessionBeanInjectionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SessionBeanInjectionTest.class)).build();
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="5.5", id="a"), @SpecAssertion(section="5.5.2", id="aa"), @SpecAssertion(section="5.5.2", id="ab"), @SpecAssertion(section="5.5.2", id="ba"), @SpecAssertion(section="5.5.2", id="be")})
    public void testInjectionOnContextualSessionBean() {
        assert (this.getInstanceByType(FarmLocal.class, new Annotation[0]).isInjectionPerformedCorrectly());
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="5.5", id="c"), @SpecAssertion(section="5.5.2", id="ak"), @SpecAssertion(section="5.5.2", id="al")})
    public void testInjectionOnNonContextualSessionBean() {
        assert (this.getInstanceByType(InjectedSessionBeanLocal.class, new Annotation[0]).getFarm().isInjectionPerformedCorrectly());
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="5.5", id="ed"), @SpecAssertion(section="5.5.2", id="ao"), @SpecAssertion(section="5.5.2", id="ap")})
    public void testInjectionOnEJBInterceptor() {
        assert (this.getInstanceByType(FarmLocal.class, new Annotation[0]).getAnimalCount() == 2);
        assert (this.getInstanceByType(InjectedSessionBeanLocal.class, new Annotation[0]).getFarm().getAnimalCount() == 2);
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="4.2", id="ab")
    public void testFieldDeclaredInSuperclassInjected() {
        DeluxeHenHouseLocal henHouse = this.getInstanceByType(DeluxeHenHouseLocal.class, new Annotation[0]);
        assert (henHouse.getFox() != null);
        assert (henHouse.getFox().getName().equals("gavin"));
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="4.2", id="ad")
    public void testFieldDeclaredInSuperclassIndirectlyInjected() {
        MegaPoorHenHouseLocal henHouse = this.getInstanceByType(MegaPoorHenHouseLocal.class, new Annotation[0]);
        assert (henHouse.getFox() != null);
        assert (henHouse.getFox().getName().equals("gavin"));
    }
}

