/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.veto;

import java.lang.annotation.Annotation;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.AnyLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.AnnotatedTypeWrapper;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.AnnotatedWrapper;
import org.jboss.cdi.tck.tests.veto.Elephant;
import org.jboss.cdi.tck.tests.veto.Leopard;
import org.jboss.cdi.tck.tests.veto.Lion;
import org.jboss.cdi.tck.tests.veto.ModifyingExtension;
import org.jboss.cdi.tck.tests.veto.Tiger;
import org.jboss.cdi.tck.tests.veto.VerifyingExtension;
import org.jboss.cdi.tck.tests.veto.aquarium.Piranha;
import org.jboss.cdi.tck.tests.veto.pen.Giraffe;
import org.jboss.cdi.tck.tests.veto.pen.Rhino;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class VetoTest
extends AbstractTest {
    @Inject
    private VerifyingExtension verifyingExtension;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(VetoTest.class)).withClasses(AnnotatedTypeWrapper.class, AnnotatedWrapper.class)).withExtensions(ModifyingExtension.class, VerifyingExtension.class)).build()).addPackage(Piranha.class.getPackage())).addPackage(Giraffe.class.getPackage());
    }

    @Test
    @SpecAssertion(section="3.12", id="a")
    public void testClassLevelVeto() {
        Assert.assertTrue((boolean)this.verifyingExtension.getClasses().contains(Elephant.class));
        Assert.assertEquals((int)this.getCurrentManager().getBeans(Elephant.class, new Annotation[]{AnyLiteral.INSTANCE}).size(), (int)0);
    }

    @Test
    @SpecAssertion(section="3.12", id="a")
    public void testPackageLevelVeto() {
        Assert.assertTrue((boolean)this.verifyingExtension.getClasses().contains(Piranha.class));
        Assert.assertEquals((int)this.getCurrentManager().getBeans(Piranha.class, new Annotation[]{AnyLiteral.INSTANCE}).size(), (int)0);
    }

    @Test
    @SpecAssertion(section="3.12", id="b")
    public void testClassLevelRequirements() {
        Assert.assertTrue((boolean)this.verifyingExtension.getClasses().contains(Lion.class));
        Assert.assertTrue((boolean)this.verifyingExtension.getClasses().contains(Tiger.class));
        Assert.assertEquals((int)this.getCurrentManager().getBeans(Lion.class, new Annotation[]{AnyLiteral.INSTANCE}).size(), (int)1);
        Assert.assertEquals((int)this.getCurrentManager().getBeans(Tiger.class, new Annotation[]{AnyLiteral.INSTANCE}).size(), (int)0);
    }

    @Test
    @SpecAssertion(section="3.12", id="b")
    public void testPackageLevelRequirements() {
        Assert.assertTrue((boolean)this.verifyingExtension.getClasses().contains(Rhino.class));
        Assert.assertTrue((boolean)this.verifyingExtension.getClasses().contains(Giraffe.class));
        Assert.assertEquals((int)this.getCurrentManager().getBeans(Rhino.class, new Annotation[]{AnyLiteral.INSTANCE}).size(), (int)0);
        Assert.assertEquals((int)this.getCurrentManager().getBeans(Giraffe.class, new Annotation[]{AnyLiteral.INSTANCE}).size(), (int)0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.12", id="a"), @SpecAssertion(section="3.12", id="b")})
    public void testReplacingAnnotatedTypeWithExtension() {
        Assert.assertTrue((boolean)this.verifyingExtension.getClasses().contains(Leopard.class));
        Assert.assertEquals((int)this.getCurrentManager().getBeans(Leopard.class, new Annotation[]{AnyLiteral.INSTANCE}).size(), (int)1);
    }
}

