/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Inject;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.cdi.tck.api.Configuration;
import org.jboss.cdi.tck.impl.ConfigurationFactory;
import org.jboss.cdi.tck.impl.OldSPIBridge;

public abstract class AbstractTest
extends Arquillian {
    @Inject
    protected BeanManager beanManager;

    protected BeanManager getCurrentManager() {
        return this.beanManager;
    }

    protected byte[] serialize(Object instance) throws IOException {
        return this.getCurrentConfiguration().getBeans().serialize(instance);
    }

    protected Object deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        return this.getCurrentConfiguration().getBeans().deserialize(bytes);
    }

    protected void setContextActive(Context context) {
        this.getCurrentConfiguration().getContexts().setActive(context);
    }

    protected void setContextInactive(Context context) {
        this.getCurrentConfiguration().getContexts().setInactive(context);
    }

    protected void destroyContext(Context context) {
        this.getCurrentConfiguration().getContexts().destroyContext(context);
    }

    protected Configuration getCurrentConfiguration() {
        return ConfigurationFactory.get();
    }

    public boolean annotationSetMatches(Set<? extends Annotation> annotations, Class<? extends Annotation> ... requiredAnnotationTypes) {
        ArrayList<Class<? extends Annotation>> annotationTypeList = new ArrayList<Class<? extends Annotation>>();
        annotationTypeList.addAll(Arrays.asList(requiredAnnotationTypes));
        for (Annotation annotation : annotations) {
            if (annotationTypeList.contains(annotation.annotationType())) {
                annotationTypeList.remove(annotation.annotationType());
                continue;
            }
            return false;
        }
        return annotationTypeList.size() == 0;
    }

    public boolean annotationSetMatches(Set<? extends Annotation> annotations, Annotation ... requiredAnnotations) {
        ArrayList requiredAnnotationList = new ArrayList();
        return requiredAnnotations.length == annotations.size() && annotations.containsAll(requiredAnnotationList);
    }

    public boolean rawTypeSetMatches(Set<Type> types, Class<?> ... requiredTypes) {
        ArrayList typeList = new ArrayList();
        typeList.addAll(Arrays.asList(requiredTypes));
        for (Type type : types) {
            if (type instanceof Class) {
                typeList.remove(type);
                continue;
            }
            if (!(type instanceof ParameterizedType)) continue;
            typeList.remove(((ParameterizedType)type).getRawType());
        }
        return typeList.size() == 0;
    }

    public boolean typeSetMatches(Collection<? extends Type> types, Type ... requiredTypes) {
        List<Type> typeList = Arrays.asList(requiredTypes);
        return requiredTypes.length == types.size() && types.containsAll(typeList);
    }

    public <T> Bean<T> getUniqueBean(Class<T> type, Annotation ... bindings) {
        Set<Bean<T>> beans = this.getBeans(type, bindings);
        return this.resolveUniqueBean(type, beans);
    }

    public <T> Bean<T> getUniqueBean(TypeLiteral<T> type, Annotation ... bindings) {
        Set<Bean<T>> beans = this.getBeans(type, bindings);
        return this.resolveUniqueBean(type.getType(), beans);
    }

    public <T> Set<Bean<T>> getBeans(Class<T> type, Annotation ... bindings) {
        return this.getCurrentManager().getBeans(type, bindings);
    }

    public <T> Set<Bean<T>> getBeans(TypeLiteral<T> type, Annotation ... bindings) {
        return this.getCurrentManager().getBeans(type.getType(), bindings);
    }

    public <T> T getInstanceByType(Class<T> beanType, Annotation ... bindings) {
        return OldSPIBridge.getInstanceByType(this.getCurrentManager(), beanType, bindings);
    }

    public <T> T getInstanceByType(TypeLiteral<T> beanType, Annotation ... bindings) {
        return OldSPIBridge.getInstanceByType(this.getCurrentManager(), beanType, bindings);
    }

    public Object getInstanceByName(String name) {
        return OldSPIBridge.getInstanceByName(this.getCurrentManager(), name);
    }

    private <T> Bean<T> resolveUniqueBean(Type type, Set<Bean<T>> beans) {
        if (beans.size() == 0) {
            throw new UnsatisfiedResolutionException("Unable to resolve any beans of " + type);
        }
        if (beans.size() > 1) {
            throw new AmbiguousResolutionException("More than one bean available (" + beans + ")");
        }
        return beans.iterator().next();
    }

    protected boolean isThrowablePresent(Class<? extends Throwable> throwableType, Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwableType.isAssignableFrom(throwable.getClass())) {
            return true;
        }
        return this.isThrowablePresent(throwableType, throwable.getCause());
    }
}

