/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.alternative;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.alternative.Animal;
import org.jboss.cdi.tck.tests.alternative.Bird;
import org.jboss.cdi.tck.tests.alternative.Cat;
import org.jboss.cdi.tck.tests.alternative.Chicken;
import org.jboss.cdi.tck.tests.alternative.Dog;
import org.jboss.cdi.tck.tests.alternative.EnabledAlternativeStereotype;
import org.jboss.cdi.tck.tests.alternative.EnabledSheepProducer;
import org.jboss.cdi.tck.tests.alternative.Horse;
import org.jboss.cdi.tck.tests.alternative.Sheep;
import org.jboss.cdi.tck.tests.alternative.Tame;
import org.jboss.cdi.tck.tests.alternative.Wild;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class AlternativeAvailabilityTest
extends AbstractTest {
    private static final AnnotationLiteral<Wild> WILD_LITERAL = new AnnotationLiteral<Wild>(){};
    private static final AnnotationLiteral<Tame> TAME_LITERAL = new AnnotationLiteral<Tame>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AlternativeAvailabilityTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createAlternatives().clazz(new String[]{Chicken.class.getName(), EnabledSheepProducer.class.getName()}).stereotype(new String[]{EnabledAlternativeStereotype.class.getName()}).up())).build();
    }

    @Test(groups={"alternatives"})
    @SpecAssertions(value={@SpecAssertion(section="5.1", id="e"), @SpecAssertion(section="5.1.1", id="c"), @SpecAssertion(section="5.1.1", id="ea"), @SpecAssertion(section="2.6", id="a"), @SpecAssertion(section="2.6.1", id="a"), @SpecAssertion(section="12.4", id="ka")})
    public void testAlternativeAvailability() throws Exception {
        Set<Bean<Animal>> animals = this.getBeans(Animal.class, new Annotation[0]);
        HashSet types = new HashSet();
        for (Bean<Animal> animal : animals) {
            types.addAll(animal.getTypes());
        }
        Assert.assertTrue((boolean)types.contains(Chicken.class));
        Assert.assertTrue((boolean)types.contains(Cat.class));
        Assert.assertTrue((boolean)types.contains(Bird.class));
        Assert.assertFalse((boolean)types.contains(Horse.class));
        Assert.assertFalse((boolean)types.contains(Dog.class));
        Assert.assertEquals((int)this.getCurrentManager().getBeans("cat").size(), (int)1);
        Assert.assertEquals((int)this.getCurrentManager().getBeans("dog").size(), (int)0);
    }

    @Test(groups={"alternatives"})
    @SpecAssertion(section="11.1", id="bc")
    public void testIsAlternative() {
        Bean cat = this.getCurrentManager().resolve(this.getCurrentManager().getBeans(Cat.class, new Annotation[0]));
        Assert.assertTrue((boolean)cat.isAlternative());
    }

    @Test(groups={"alternatives"})
    @SpecAssertions(value={@SpecAssertion(section="5.1.1", id="g"), @SpecAssertion(section="2.6.1", id="b"), @SpecAssertion(section="2.7", id="aa"), @SpecAssertion(section="2.7.1.4", id="a")})
    public void testAnyEnabledAlternativeStereotypeMakesAlternativeEnabled() throws Exception {
        Assert.assertEquals((int)this.getBeans(Bird.class, new Annotation[0]).size(), (int)1);
        Assert.assertEquals((int)this.getCurrentManager().getBeans("bird").size(), (int)1);
    }

    @Test(groups={"alternatives"})
    @SpecAssertions(value={@SpecAssertion(section="5.1.1", id="fa")})
    public void testProducersOnAlternativeClass() throws Exception {
        Assert.assertEquals((int)this.getBeans(Sheep.class, new Annotation[]{WILD_LITERAL}).size(), (int)2);
        Assert.assertEquals((int)this.getBeans(Sheep.class, new Annotation[]{TAME_LITERAL}).size(), (int)0);
    }

    @Test(groups={"alternatives"})
    @SpecAssertions(value={@SpecAssertion(section="2.6.1", id="ab"), @SpecAssertion(section="2.6.1", id="ac")})
    public void testProducerAlternativesOnMethodAndField() throws Exception {
        Assert.assertEquals((int)this.getBeans(Cat.class, new Annotation[]{WILD_LITERAL}).size(), (int)2);
        Assert.assertEquals((int)this.getBeans(Cat.class, new Annotation[]{TAME_LITERAL}).size(), (int)0);
    }

    @Test(groups={"alternatives"})
    @SpecAssertions(value={@SpecAssertion(section="2.6.1", id="c"), @SpecAssertion(section="2.6.1", id="d")})
    public void testStereotypeAlternativeOnProducerMethodAndField() throws Exception {
        Assert.assertEquals((int)this.getBeans(Bird.class, new Annotation[]{WILD_LITERAL}).size(), (int)0);
        Assert.assertEquals((int)this.getBeans(Bird.class, new Annotation[]{TAME_LITERAL}).size(), (int)2);
    }
}

