/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.annotation.WebListener;
import org.jboss.cdi.tck.tests.context.request.RequestContextGuard;
import org.jboss.cdi.tck.tests.context.request.SimpleRequestBean;
import org.jboss.cdi.tck.util.SimpleLogger;

@WebListener
public class TestServletRequestListener
implements ServletRequestListener {
    private static final SimpleLogger logger = new SimpleLogger(TestServletRequestListener.class);
    @Inject
    private BeanManager beanManager;
    @Inject
    private SimpleRequestBean simpleBean;
    @Inject
    private RequestContextGuard guard;

    public void requestDestroyed(ServletRequestEvent sre) {
        logger.log("Request destroyed...", new Object[0]);
        this.checkRequestContextActive();
        String mode = sre.getServletRequest().getParameter("guard");
        if (mode != null && mode.equals("collect")) {
            this.guard.setServletRequestListenerCheckpoint(System.currentTimeMillis());
        }
    }

    public void requestInitialized(ServletRequestEvent sre) {
    }

    private void checkRequestContextActive() throws IllegalStateException {
        if (this.beanManager == null || !this.beanManager.getContext(RequestScoped.class).isActive() || this.simpleBean == null) {
            throw new IllegalStateException("Request context is not active");
        }
        this.simpleBean.getId();
    }
}

