/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request.ws;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import javax.xml.namespace.QName;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.request.ws.Translator;
import org.jboss.cdi.tck.tests.context.request.ws.TranslatorEndpointService;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"javaee-full"})
@SpecVersion(spec="cdi", version="20091101")
public class RequestContextTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(RequestContextTest.class)).withExcludedClass(TranslatorEndpointService.class.getName())).withWebXml((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).createServlet().servletName("Translator").servletClass("org.jboss.cdi.tck.tests.context.request.ws.TranslatorEndpoint").loadOnStartup(Integer.valueOf(1)).up()).createServletMapping().servletName("Translator").urlPattern(new String[]{"/translator"}).up())).build();
    }

    @Test(groups={"contexts"})
    @SpecAssertions(value={@SpecAssertion(section="6.7.1", id="c"), @SpecAssertion(section="6.7.1", id="d"), @SpecAssertion(section="6.7.3", id="b")})
    public void testRequestScopeActiveDuringWebServiceInvocation() throws Exception {
        URL wsdlLocation = new URL(this.contextPath.toExternalForm() + "translator?wsdl");
        TranslatorEndpointService endpointService = new TranslatorEndpointService(wsdlLocation, new QName("http://ws.request.context.tests.tck.cdi.jboss.org/", "Translator"));
        Translator translator = endpointService.getTranslatorPort();
        Long id01 = Long.valueOf(translator.translate());
        Long id02 = Long.valueOf(translator.translate());
        Assert.assertNotEquals((Object)id01, (Object)id02);
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage info = (TextPage)webClient.getPage(this.contextPath + "info");
        Assert.assertTrue((boolean)info.getContent().contains("Foo destroyed:2"));
    }
}

