/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.fires;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import org.jboss.cdi.tck.tests.event.fires.Item;
import org.jboss.cdi.tck.tests.event.fires.Lifted;
import org.jboss.cdi.tck.tests.event.fires.MiniBar;

@RequestScoped
class Billing {
    private boolean active = false;
    private double charge = 0.0;
    private double miniBarValue = 0.0;
    private Set<Item> itemsPurchased = new HashSet<Item>();

    Billing() {
    }

    public void billForItem(@Observes @Lifted Item item) {
        if (this.itemsPurchased.add(item)) {
            this.charge += item.getPrice();
        }
    }

    public double getCharge() {
        return this.charge;
    }

    public double getMiniBarValue() {
        return this.miniBarValue;
    }

    public boolean isActive() {
        return this.active;
    }

    public void activate(@Observes @Any MiniBar minibar) {
        this.active = true;
        this.miniBarValue = 0.0;
        for (Item item : minibar.getItems()) {
            this.miniBarValue += item.getPrice();
        }
    }

    public void reset() {
        this.active = false;
        this.itemsPurchased.clear();
        this.charge = 0.0;
    }
}

