/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.fires;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Event;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.AnyLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.fires.Bar;
import org.jboss.cdi.tck.tests.event.fires.Billing;
import org.jboss.cdi.tck.tests.event.fires.DogWhisperer;
import org.jboss.cdi.tck.tests.event.fires.DoggiePoints;
import org.jboss.cdi.tck.tests.event.fires.Housekeeping;
import org.jboss.cdi.tck.tests.event.fires.Item;
import org.jboss.cdi.tck.tests.event.fires.Item_Illegal;
import org.jboss.cdi.tck.tests.event.fires.Lifted;
import org.jboss.cdi.tck.tests.event.fires.MiniBar;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class FireEventTest
extends AbstractTest {
    private static final String BEAN_MANAGER_FIRE_EVENT_METHOD_NAME = "fireEvent";

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(FireEventTest.class)).build();
    }

    @Test(groups={"events"})
    @SpecAssertions(value={@SpecAssertion(section="11.3.10", id="a"), @SpecAssertion(section="11.3.10", id="b")})
    public void testBeanManagerInterfaceForFireEventMethod() throws Exception {
        assert (BeanManager.class.getDeclaredMethod(BEAN_MANAGER_FIRE_EVENT_METHOD_NAME, Object.class, Annotation[].class) != null);
    }

    @Test(groups={"events"})
    @SpecAssertion(section="11.3.10", id="a")
    public void testBeanManagerFireEvent() {
        Billing billing = this.getInstanceByType(Billing.class, new Annotation[0]);
        billing.reset();
        MiniBar miniBar = new MiniBar();
        miniBar.stockNoNotify();
        this.getCurrentManager().fireEvent((Object)miniBar, new Annotation[0]);
        assert (billing.isActive());
        Item chocolate = miniBar.getItemByName("Chocolate");
        this.getCurrentManager().fireEvent((Object)chocolate, new Annotation[]{new AnnotationLiteral<Lifted>(){}});
        assert (billing.getCharge() == 5.0);
    }

    @Test(groups={"events"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="11.3.10", id="c")
    public void testTypeVariableEventTypeFails() throws Exception {
        this.getInstanceByType(Bar.class, new Annotation[0]).fireWithTypeVariable();
    }

    @Test(groups={"events"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="11.3.10", id="d")
    public void testDuplicateBindingsToFireEventFails() throws Exception {
        this.getCurrentManager().fireEvent(new Object(), new Annotation[]{new AnnotationLiteral<Lifted>(){}, new AnnotationLiteral<Lifted>(){}});
    }

    @Test(groups={"events"})
    @SpecAssertion(section="10.3", id="a")
    public void testInjectedAnyEventCanFireEvent() {
        Billing billing = this.getInstanceByType(Billing.class, new Annotation[0]);
        billing.reset();
        Bean<MiniBar> miniBarBean = this.getUniqueBean(MiniBar.class, new Annotation[0]);
        InjectionPoint eventInjection = null;
        for (InjectionPoint candidate : miniBarBean.getInjectionPoints()) {
            if (!candidate.getMember().getName().equals("miniBarEvent")) continue;
            eventInjection = candidate;
            break;
        }
        assert (eventInjection != null);
        assert (eventInjection.getQualifiers().size() == 1);
        assert (eventInjection.getQualifiers().contains(AnyLiteral.INSTANCE));
        CreationalContext miniBarCc = this.getCurrentManager().createCreationalContext(miniBarBean);
        MiniBar miniBar = (MiniBar)miniBarBean.create(miniBarCc);
        miniBar.stock();
        assert (billing.isActive());
        assert (billing.getMiniBarValue() == 16.0);
    }

    @Test(groups={"events"})
    @SpecAssertions(value={@SpecAssertion(section="10.3", id="b"), @SpecAssertion(section="10.3.1", id="cb")})
    public void testInjectedEventAcceptsEventObject() throws SecurityException, NoSuchFieldException, NoSuchMethodException {
        Billing billing = this.getInstanceByType(Billing.class, new Annotation[0]);
        billing.reset();
        Bean<MiniBar> miniBarBean = this.getUniqueBean(MiniBar.class, new Annotation[0]);
        CreationalContext miniBarCc = this.getCurrentManager().createCreationalContext(miniBarBean);
        MiniBar miniBar = (MiniBar)miniBarBean.create(miniBarCc);
        Field eventField = miniBar.getClass().getDeclaredField("miniBarEvent");
        ParameterizedType eventFieldType = (ParameterizedType)eventField.getGenericType();
        assert (eventFieldType.getActualTypeArguments().length == 1);
        assert (MiniBar.class.equals((Object)eventFieldType.getActualTypeArguments()[0]));
        assert (Event.class.equals((Object)eventFieldType.getRawType()));
        Method fireMethod = null;
        Class eventFieldClass = (Class)eventFieldType.getRawType();
        for (Method method : eventFieldClass.getMethods()) {
            if (!method.getName().equals("fire") || method.isSynthetic()) continue;
            if (fireMethod != null) assert (false) : "Expecting exactly one method on Event named 'fire'";
            fireMethod = method;
        }
        if (fireMethod == null) assert (false) : "Expecting exactly one method on Event named 'fire'";
        assert (fireMethod.getParameterTypes().length == 1);
        assert (fireMethod.getGenericParameterTypes().length == 1);
        Type fireMethodArgumentType = fireMethod.getGenericParameterTypes()[0];
        TypeVariable<?> eventClassParameterizedType = ((TypeVariable)fireMethod.getGenericParameterTypes()[0]).getGenericDeclaration().getTypeParameters()[0];
        assert (fireMethodArgumentType.equals(eventClassParameterizedType));
        miniBar.stock();
        assert (billing.isActive());
        assert (billing.getMiniBarValue() == 16.0);
    }

    @Test(groups={"events"})
    @SpecAssertions(value={@SpecAssertion(section="10.3", id="c"), @SpecAssertion(section="10.3.1", id="cb")})
    public void testInjectedEventCanHaveBindings() {
        Billing billing = this.getInstanceByType(Billing.class, new Annotation[0]);
        billing.reset();
        Bean<MiniBar> miniBarBean = this.getUniqueBean(MiniBar.class, new Annotation[0]);
        InjectionPoint eventInjection = null;
        for (InjectionPoint candidate : miniBarBean.getInjectionPoints()) {
            if (!candidate.getMember().getName().equals("itemLiftedEvent")) continue;
            eventInjection = candidate;
            break;
        }
        assert (eventInjection != null);
        assert (eventInjection.getQualifiers().size() == 1);
        assert (eventInjection.getQualifiers().contains(new AnnotationLiteral<Lifted>(){}));
        CreationalContext miniBarCc = this.getCurrentManager().createCreationalContext(miniBarBean);
        MiniBar miniBar = (MiniBar)miniBarBean.create(miniBarCc);
        miniBar.stock();
        Item chocolate = miniBar.getItemByName("Chocolate");
        assert (chocolate != null);
        miniBar.liftItem(chocolate);
        assert (billing.getCharge() == chocolate.getPrice());
    }

    @Test(groups={"events"})
    @SpecAssertion(section="10.3", id="d")
    public void testInjectedEventCanSpecifyBindingsDynamically() {
        Billing billing = this.getInstanceByType(Billing.class, new Annotation[0]);
        billing.reset();
        Housekeeping housekeeping = this.getInstanceByType(Housekeeping.class, new Annotation[0]);
        Bean<MiniBar> miniBarBean = this.getUniqueBean(MiniBar.class, new Annotation[0]);
        InjectionPoint eventInjection = null;
        for (InjectionPoint candidate : miniBarBean.getInjectionPoints()) {
            if (!candidate.getMember().getName().equals("itemEvent")) continue;
            eventInjection = candidate;
            break;
        }
        assert (eventInjection != null);
        assert (eventInjection.getQualifiers().size() == 1);
        assert (eventInjection.getQualifiers().contains(AnyLiteral.INSTANCE));
        CreationalContext miniBarCc = this.getCurrentManager().createCreationalContext(miniBarBean);
        MiniBar miniBar = (MiniBar)miniBarBean.create(miniBarCc);
        miniBar.stock();
        Item water = miniBar.liftItemByName("16 oz Water");
        miniBar.restoreItem(water);
        assert (billing.getCharge() == 1.0);
        assert (housekeeping.getItemsTainted().size() == 1);
        assert (housekeeping.getItemsTainted().contains(water));
    }

    @Test(groups={"events"})
    @SpecAssertion(section="10.3.1", id="ca")
    public void testEventProvidesMethodForFiringEventsWithCombinationOfTypeAndBindings() {
        DoggiePoints points = this.getInstanceByType(DoggiePoints.class, new Annotation[0]);
        points.reset();
        DogWhisperer master = this.getInstanceByType(DogWhisperer.class, new Annotation[0]);
        master.issueTamingCommand();
        assert (points.getNumTamed() == 1);
        assert (points.getNumPraiseReceived() == 0);
        master.givePraise();
        assert (points.getNumTamed() == 1);
        assert (points.getNumPraiseReceived() == 1);
    }

    @Test(groups={"events"})
    @SpecAssertion(section="10.3.1", id="eda")
    public void testEventSelectedFiresAndObserversNotified() {
        Housekeeping houseKeeping = this.getInstanceByType(Housekeeping.class, new Annotation[0]);
        houseKeeping.reset();
        MiniBar miniBar = this.getInstanceByType(MiniBar.class, new Annotation[0]);
        Item chocolate = new Item("Chocolate", 5.0);
        Item crackers = new Item("Crackers", 2.5);
        miniBar.getItemEvent().fire((Object)chocolate);
        assert (houseKeeping.getItemActivity().size() == 1);
        assert (houseKeeping.getItemActivity().get(0) == chocolate);
        miniBar.getItemEvent().select(new Annotation[]{new AnnotationLiteral<Lifted>(){}}).fire((Object)crackers);
        assert (houseKeeping.getItemActivity().size() == 2);
        assert (houseKeeping.getItemActivity().get(1) == crackers);
        assert (houseKeeping.getItemsMissing().size() == 1);
        assert (houseKeeping.getItemsMissing().iterator().next() == crackers);
    }

    @Test(groups={"events"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertions(value={@SpecAssertion(section="10.3.1", id="f"), @SpecAssertion(section="10.2", id="j")})
    public <T> void testEventFireThrowsExceptionIfEventObjectContainsTypeVariable() {
        MiniBar miniBar = this.getInstanceByType(MiniBar.class, new Annotation[0]);
        miniBar.itemEvent.fire(new Item_Illegal("12 oz Beer", 5.5));
    }
}

