/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.afterBeanDiscovery;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.Context;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.afterBeanDiscovery.AfterBeanDiscoveryObserver;
import org.jboss.cdi.tck.tests.extensions.afterBeanDiscovery.Cockatoo;
import org.jboss.cdi.tck.tests.extensions.afterBeanDiscovery.SuperContext;
import org.jboss.cdi.tck.tests.extensions.afterBeanDiscovery.SuperScoped;
import org.jboss.cdi.tck.tests.extensions.afterBeanDiscovery.Talk;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class AfterBeanDiscoveryTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AfterBeanDiscoveryTest.class)).withExtension("javax.enterprise.inject.spi.Extension")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.5.2", id="db")})
    public void testBeanIsAdded() {
        assert (this.getBeans(Cockatoo.class, new Annotation[0]).size() == 1);
        assert (this.getInstanceByType(Cockatoo.class, new Annotation[0]).getName().equals("Billy"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.5.2", id="da")})
    public void testProcessBeanIsFired() {
        assert (AfterBeanDiscoveryObserver.isProcessBeanFiredForCockatooBean);
    }

    @Test
    @SpecAssertion(section="11.5.2", id="ea")
    public void testProcessObserverMethodFiredWhileAddingObserverMethod() {
        Assert.assertTrue((boolean)AfterBeanDiscoveryObserver.isTalkProcessObserverMethodObserved);
    }

    @Test
    @SpecAssertion(section="11.5.2", id="eb")
    public void testObserverMethodRegistered() {
        this.getCurrentManager().fireEvent((Object)new Talk("Hello"), new Annotation[0]);
        Assert.assertTrue((boolean)AfterBeanDiscoveryObserver.addedObserverMethod.isObserved());
    }

    @Test
    @SpecAssertion(section="11.5.2", id="f")
    public void testAddContext() {
        Context context = this.getCurrentManager().getContext(SuperScoped.class);
        Assert.assertNotNull((Object)context);
        Assert.assertTrue((boolean)context.isActive());
        Assert.assertTrue((boolean)(context instanceof SuperContext));
    }
}

