/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.beanManager.beanAttributes;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.inject.Named;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.NamedLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.AnnotatedTypeWrapper;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.AnnotatedWrapper;
import org.jboss.cdi.tck.tests.extensions.beanManager.beanAttributes.Animal;
import org.jboss.cdi.tck.tests.extensions.beanManager.beanAttributes.Dam;
import org.jboss.cdi.tck.tests.extensions.beanManager.beanAttributes.Fish;
import org.jboss.cdi.tck.tests.extensions.beanManager.beanAttributes.InvalidBeanType;
import org.jboss.cdi.tck.tests.extensions.beanManager.beanAttributes.Lake;
import org.jboss.cdi.tck.tests.extensions.beanManager.beanAttributes.LakeLocal;
import org.jboss.cdi.tck.tests.extensions.beanManager.beanAttributes.Landmark;
import org.jboss.cdi.tck.tests.extensions.beanManager.beanAttributes.Mountain;
import org.jboss.cdi.tck.tests.extensions.beanManager.beanAttributes.Natural;
import org.jboss.cdi.tck.tests.extensions.beanManager.beanAttributes.TundraStereotype;
import org.jboss.cdi.tck.tests.extensions.beanManager.beanAttributes.WaterBody;
import org.jboss.cdi.tck.tests.extensions.beanManager.beanAttributes.Wild;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class CreateBeanAttributesTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(CreateBeanAttributesTest.class)).withClasses(AnnotatedTypeWrapper.class, AnnotatedWrapper.class)).build();
    }

    @Test
    @SpecAssertion(section="11.3.22", id="a")
    public void testBeanAttributesForManagedBean() {
        AnnotatedType type = this.getCurrentManager().createAnnotatedType(Mountain.class);
        BeanAttributes attributes = this.getCurrentManager().createBeanAttributes(type);
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{Landmark.class, Object.class}));
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getStereotypes(), new Type[]{TundraStereotype.class}));
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)attributes.getQualifiers(), Natural.class, Any.class));
        Assert.assertEquals((Object)attributes.getScope(), ApplicationScoped.class);
        Assert.assertEquals((String)attributes.getName(), (String)"mountain");
        Assert.assertTrue((boolean)attributes.isAlternative());
        Assert.assertTrue((boolean)attributes.isNullable());
    }

    @Test
    @SpecAssertion(section="11.3.22", id="a")
    public void testBeanAttributesForManagedBeanWithModifiedAnnotatedType() {
        AnnotatedType type = this.getCurrentManager().createAnnotatedType(Mountain.class);
        AnnotatedTypeWrapper wrappedType = new AnnotatedTypeWrapper(type, false, new Annotation[]{new NamedLiteral("Mount Blanc")});
        BeanAttributes attributes = this.getCurrentManager().createBeanAttributes(wrappedType);
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{Mountain.class, Landmark.class, Object.class}));
        Assert.assertTrue((boolean)attributes.getStereotypes().isEmpty());
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)attributes.getQualifiers(), Named.class, Any.class, Default.class));
        Assert.assertEquals((Object)attributes.getScope(), Dependent.class);
        Assert.assertEquals((String)attributes.getName(), (String)"Mount Blanc");
        Assert.assertFalse((boolean)attributes.isAlternative());
        Assert.assertTrue((boolean)attributes.isNullable());
    }

    @Test
    @SpecAssertion(section="11.3.22", id="a")
    public void testBeanAttributesForSessionBean() {
        AnnotatedType type = this.getCurrentManager().createAnnotatedType(Lake.class);
        BeanAttributes attributes = this.getCurrentManager().createBeanAttributes(type);
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{LakeLocal.class, WaterBody.class, Landmark.class, Object.class}));
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getStereotypes(), new Type[]{TundraStereotype.class}));
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)attributes.getQualifiers(), Natural.class, Any.class));
        Assert.assertEquals((Object)attributes.getScope(), Dependent.class);
        Assert.assertEquals((String)attributes.getName(), (String)"lake");
        Assert.assertTrue((boolean)attributes.isAlternative());
        Assert.assertTrue((boolean)attributes.isNullable());
    }

    @Test
    @SpecAssertion(section="11.3.22", id="b")
    public void testBeanAttributesForMethod() {
        AnnotatedType type = this.getCurrentManager().createAnnotatedType(Dam.class);
        AnnotatedMethod lakeFishMethod = null;
        AnnotatedMethod damFishMethod = null;
        AnnotatedMethod volumeMethod = null;
        for (AnnotatedMethod method : type.getMethods()) {
            if (method.getJavaMember().getName().equals("getFish") && method.getJavaMember().getDeclaringClass().equals(Dam.class)) {
                damFishMethod = method;
            }
            if (method.getJavaMember().getName().equals("getFish") && method.getJavaMember().getDeclaringClass().equals(Lake.class)) {
                lakeFishMethod = method;
            }
            if (!method.getJavaMember().getName().equals("getVolume") || !method.getJavaMember().getDeclaringClass().equals(Lake.class)) continue;
            volumeMethod = method;
        }
        Assert.assertNotNull(lakeFishMethod);
        Assert.assertNotNull(damFishMethod);
        Assert.assertNotNull(volumeMethod);
        this.verifyLakeFish(this.getCurrentManager().createBeanAttributes(lakeFishMethod));
        this.verifyDamFish(this.getCurrentManager().createBeanAttributes(damFishMethod));
        this.verifyVolume(this.getCurrentManager().createBeanAttributes(volumeMethod));
    }

    @Test
    @SpecAssertion(section="11.3.22", id="b")
    public void testBeanAttributesForField() {
        AnnotatedType type = this.getCurrentManager().createAnnotatedType(Dam.class);
        AnnotatedField lakeFishField = null;
        AnnotatedField damFishField = null;
        AnnotatedField volumeField = null;
        for (AnnotatedField field : type.getFields()) {
            if (field.getJavaMember().getName().equals("fish") && field.getJavaMember().getDeclaringClass().equals(Dam.class)) {
                damFishField = field;
            }
            if (field.getJavaMember().getName().equals("fish") && field.getJavaMember().getDeclaringClass().equals(Lake.class)) {
                lakeFishField = field;
            }
            if (!field.getJavaMember().getName().equals("volume") || !field.getJavaMember().getDeclaringClass().equals(Lake.class)) continue;
            volumeField = field;
        }
        Assert.assertNotNull(lakeFishField);
        Assert.assertNotNull(damFishField);
        Assert.assertNotNull(volumeField);
        this.verifyLakeFish(this.getCurrentManager().createBeanAttributes(lakeFishField));
        this.verifyDamFish(this.getCurrentManager().createBeanAttributes(damFishField));
        this.verifyVolume(this.getCurrentManager().createBeanAttributes(volumeField));
    }

    private void verifyLakeFish(BeanAttributes<?> attributes) {
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{Fish.class, Object.class}));
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getStereotypes(), new Type[]{TundraStereotype.class}));
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)attributes.getQualifiers(), Natural.class, Any.class, Named.class));
        Assert.assertEquals((Object)attributes.getScope(), ApplicationScoped.class);
        Assert.assertEquals((String)attributes.getName(), (String)"fish");
        Assert.assertTrue((boolean)attributes.isAlternative());
        Assert.assertTrue((boolean)attributes.isNullable());
    }

    private void verifyDamFish(BeanAttributes<?> attributes) {
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{Fish.class, Animal.class, Object.class}));
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)attributes.getQualifiers(), Wild.class, Any.class));
        Assert.assertTrue((boolean)attributes.getStereotypes().isEmpty());
        Assert.assertEquals((Object)attributes.getScope(), Dependent.class);
        Assert.assertNull((Object)attributes.getName());
        Assert.assertFalse((boolean)attributes.isAlternative());
        Assert.assertTrue((boolean)attributes.isNullable());
    }

    private void verifyVolume(BeanAttributes<?> attributes) {
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{Long.TYPE, Object.class}));
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)attributes.getQualifiers(), Any.class, Default.class, Named.class));
        Assert.assertTrue((boolean)attributes.getStereotypes().isEmpty());
        Assert.assertEquals((Object)attributes.getScope(), Dependent.class);
        Assert.assertEquals((String)attributes.getName(), (String)"volume");
        Assert.assertFalse((boolean)attributes.isAlternative());
        Assert.assertFalse((boolean)attributes.isNullable());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="11.3.22", id="c")
    public void testInvalidMember() {
        AnnotatedConstructor constructor = (AnnotatedConstructor)this.getCurrentManager().createAnnotatedType(InvalidBeanType.class).getConstructors().iterator().next();
        this.getCurrentManager().createBeanAttributes((AnnotatedMember)constructor);
    }
}

