/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.container.event.ws;

import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.EnterpriseArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.container.event.ws.ProcessAnnotatedTypeObserver;
import org.jboss.cdi.tck.tests.extensions.container.event.ws.ProcessInjectionTargetObserver;
import org.jboss.cdi.tck.tests.extensions.container.event.ws.Translator;
import org.jboss.cdi.tck.tests.extensions.container.event.ws.TranslatorEndpoint;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"javaee-full"})
@SpecVersion(spec="cdi", version="20091101")
public class ContainerEventTest
extends AbstractTest {
    @Deployment
    public static EnterpriseArchive createTestArchive() {
        return (EnterpriseArchive)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)new EnterpriseArchiveBuilder().withTestClassPackage(ContainerEventTest.class)).withExtensions(ProcessInjectionTargetObserver.class, ProcessAnnotatedTypeObserver.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.5.8", id="aag"), @SpecAssertion(section="11.5.8", id="abg"), @SpecAssertion(section="12.4", id="di")})
    public void testProcessInjectionTargetFiredForWsEndpoint() {
        Assert.assertNotNull(ProcessInjectionTargetObserver.getWsEndpointEvent());
        this.validateWsEndpointAnnotatedType((AnnotatedType<TranslatorEndpoint>)ProcessInjectionTargetObserver.getWsEndpointEvent().getAnnotatedType());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="12.4", id="bi")})
    public void testProcessAnnotatedTypeFiredForWsEndpoint() {
        Assert.assertNotNull(ProcessAnnotatedTypeObserver.getWsEndpointEvent());
        this.validateWsEndpointAnnotatedType((AnnotatedType<TranslatorEndpoint>)ProcessAnnotatedTypeObserver.getWsEndpointEvent().getAnnotatedType());
    }

    private void validateWsEndpointAnnotatedType(AnnotatedType<TranslatorEndpoint> annotatedType) {
        Assert.assertEquals((Object)annotatedType.getBaseType(), TranslatorEndpoint.class);
        Assert.assertEquals((int)annotatedType.getMethods().size(), (int)1);
        Set typeClosure = annotatedType.getTypeClosure();
        Assert.assertTrue((boolean)this.typeSetMatches(typeClosure, new Type[]{Translator.class, TranslatorEndpoint.class, Object.class}));
    }
}

