/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.builtin;

import java.lang.annotation.Annotation;
import java.security.Principal;
import javax.security.auth.login.LoginException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.EnterpriseArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.builtin.DefaultValidatorFactoryInjectedBeanLocal;
import org.jboss.cdi.tck.tests.implementation.builtin.DefaultValidatorInjectedBeanLocal;
import org.jboss.cdi.tck.tests.implementation.builtin.PrincipalInjectedBeanLocal;
import org.jboss.cdi.tck.tests.implementation.builtin.UserTransactionInjectedBeanLocal;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"javaee-full"})
@SpecVersion(spec="cdi", version="20091101")
public class BuiltInBeansTest
extends AbstractTest {
    @Deployment
    public static EnterpriseArchive createTestArchive() {
        return (EnterpriseArchive)((EnterpriseArchiveBuilder)new EnterpriseArchiveBuilder().withTestClassPackage(BuiltInBeansTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.7", id="a")})
    public void testUserTransactionBean() throws SystemException {
        UserTransaction userTransaction = this.getInstanceByType(UserTransactionInjectedBeanLocal.class, new Annotation[0]).getUserTransaction();
        Assert.assertNotNull((Object)userTransaction);
        userTransaction.getStatus();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.7", id="c")})
    public void testDefaultValidatorFactoryBean() throws SystemException {
        ValidatorFactory defaultValidatorFactory = this.getInstanceByType(DefaultValidatorFactoryInjectedBeanLocal.class, new Annotation[0]).getDefaultValidatorFactory();
        Assert.assertNotNull((Object)defaultValidatorFactory);
        defaultValidatorFactory.getValidator();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.7", id="d")})
    public void testDefaultValidatorBean() throws SystemException {
        Validator defaultValidator = this.getInstanceByType(DefaultValidatorInjectedBeanLocal.class, new Annotation[0]).getDefaultValidator();
        Assert.assertNotNull((Object)defaultValidator);
        defaultValidator.getConstraintsForClass(BuiltInBeansTest.class);
    }

    @Test(groups={"rewrite"})
    @SpecAssertions(value={@SpecAssertion(section="3.7", id="b")})
    public void testPrincipalBean() throws SystemException, LoginException {
        PrincipalInjectedBeanLocal instance = this.getInstanceByType(PrincipalInjectedBeanLocal.class, new Annotation[0]);
        instance.login();
        Principal principal = instance.getPrincipal();
    }
}

