/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.builtin.metadata;

import java.lang.annotation.Annotation;
import java.util.Collections;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.builtin.metadata.Frozen;
import org.jboss.cdi.tck.tests.implementation.builtin.metadata.Fruit;
import org.jboss.cdi.tck.tests.implementation.builtin.metadata.MilkProduct;
import org.jboss.cdi.tck.tests.implementation.builtin.metadata.MilkProductDecorator;
import org.jboss.cdi.tck.tests.implementation.builtin.metadata.Probiotic;
import org.jboss.cdi.tck.tests.implementation.builtin.metadata.Yoghurt;
import org.jboss.cdi.tck.tests.implementation.builtin.metadata.YoghurtFactory;
import org.jboss.cdi.tck.tests.implementation.builtin.metadata.YoghurtInterceptor;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class BuiltinMetadataBeanTest
extends AbstractTest {
    @Inject
    private Yoghurt yoghurt;
    @Inject
    private YoghurtFactory factory;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BuiltinMetadataBeanTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createInterceptors().clazz(new String[]{YoghurtInterceptor.class.getName()}).up()).createDecorators().clazz(new String[]{MilkProductDecorator.class.getName()}).up())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5.8", id="a"), @SpecAssertion(section="5.5.8", id="f")})
    public void testBeanMetadata() {
        Bean<Yoghurt> resolvedBean = this.getUniqueBean(Yoghurt.class, new Annotation[0]);
        Assert.assertEquals(resolvedBean, this.yoghurt.getBeanBean());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5.8", id="a"), @SpecAssertion(section="5.5.8", id="f")})
    public void testProducerAndDisposerMethodMetadata() {
        Bean<Yoghurt> fruitYoghurtBean = this.getUniqueBean(Yoghurt.class, new Fruit.Literal());
        CreationalContext fruitCtx = this.getCurrentManager().createCreationalContext(fruitYoghurtBean);
        Yoghurt fruitYoghurt = (Yoghurt)this.getCurrentManager().getReference(fruitYoghurtBean, Yoghurt.class, fruitCtx);
        Assert.assertEquals(fruitYoghurtBean, this.factory.getFruitYoghurtBean());
        Bean<Yoghurt> probioticYoghurtBean = this.getUniqueBean(Yoghurt.class, new Probiotic.Literal());
        CreationalContext probioticCtx = this.getCurrentManager().createCreationalContext(probioticYoghurtBean);
        Yoghurt probioticYoghurt = (Yoghurt)this.getCurrentManager().getReference(probioticYoghurtBean, Yoghurt.class, fruitCtx);
        Assert.assertEquals(probioticYoghurtBean, this.factory.getProbioticYoghurtBean());
        fruitYoghurtBean.destroy((Object)fruitYoghurt, fruitCtx);
        probioticYoghurtBean.destroy((Object)probioticYoghurt, probioticCtx);
        Assert.assertEquals((int)this.factory.getBeans().size(), (int)2);
        Assert.assertEquals(fruitYoghurtBean, this.factory.getBeans().get(0));
        Assert.assertEquals(probioticYoghurtBean, this.factory.getBeans().get(1));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5.8", id="b"), @SpecAssertion(section="5.5.8", id="d"), @SpecAssertion(section="5.5.8", id="f")})
    public void testInterceptorMetadata() {
        Bean<Yoghurt> bean = this.getUniqueBean(Yoghurt.class, new Annotation[0]);
        Interceptor interceptor = (Interceptor)this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{new Frozen.Literal()}).iterator().next();
        YoghurtInterceptor instance = this.yoghurt.getInterceptorInstance();
        Assert.assertEquals((Object)interceptor, instance.getBean());
        Assert.assertEquals((Object)interceptor, instance.getInterceptor());
        Assert.assertEquals(bean, instance.getInterceptedBean());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5.8", id="c"), @SpecAssertion(section="5.5.8", id="e"), @SpecAssertion(section="5.5.8", id="f")})
    public void testDecoratorMetadata() {
        Bean<Yoghurt> bean = this.getUniqueBean(Yoghurt.class, new Annotation[0]);
        Decorator decorator = (Decorator)this.getCurrentManager().resolveDecorators(Collections.singleton(MilkProduct.class), new Annotation[0]).iterator().next();
        MilkProductDecorator instance = this.yoghurt.getDecoratorInstance();
        Assert.assertEquals((Object)decorator, instance.getBean());
        Assert.assertEquals((Object)decorator, instance.getDecorator());
        Assert.assertEquals(bean, instance.getDecoratedBean());
    }

    @Test(groups={"passivation"})
    @SpecAssertions(value={@SpecAssertion(section="5.5.8", id="g"), @SpecAssertion(section="5.5.8", id="f")})
    public void testIllegalInjectionDetected() {
        Assert.assertNull((Object)this.getReference(Bean.class));
        Assert.assertNull((Object)this.getReference(Interceptor.class));
        Assert.assertNull((Object)this.getReference(Decorator.class));
    }

    private Object getReference(Class<?> type) {
        Bean bean = this.getCurrentManager().resolve(this.getCurrentManager().getBeans(type, new Annotation[0]));
        CreationalContext ctx = this.getCurrentManager().createCreationalContext((Contextual)bean);
        return this.getCurrentManager().getReference(bean, type, ctx);
    }
}

