/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution.BallBindingLiteral;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution.ComplicatedInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution.LoggedBinding;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution.MessageBinding;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution.MessageService;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution.MonitorService;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution.PingBinding;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution.PongBinding;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution.RemoteMessageService;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution.TransactionalBinding;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class InterceptorBindingResolutionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InterceptorBindingResolutionTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createInterceptors().clazz(new String[]{ComplicatedInterceptor.class.getName()}).up())).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="9.5", id="ba")
    public void testBusinessMethodInterceptorBindings(MessageService messageService, MonitorService monitorService) {
        Assert.assertEquals((int)this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{new AnnotationLiteral<MessageBinding>(){}, new AnnotationLiteral<LoggedBinding>(){}, new AnnotationLiteral<TransactionalBinding>(){}, new AnnotationLiteral<PingBinding>(){}, new AnnotationLiteral<PongBinding>(){}, new BallBindingLiteral(true, true)}).size(), (int)1);
        Assert.assertNotNull((Object)messageService);
        ComplicatedInterceptor.reset();
        messageService.ping();
        Assert.assertTrue((boolean)ComplicatedInterceptor.intercepted);
        Assert.assertNotNull((Object)monitorService);
        ComplicatedInterceptor.reset();
        monitorService.ping();
        Assert.assertFalse((boolean)ComplicatedInterceptor.intercepted);
    }

    @Test
    @SpecAssertion(section="9.5", id="a")
    public void testLifecycleInterceptorBindings() throws Exception {
        Assert.assertEquals((int)this.getCurrentManager().resolveInterceptors(InterceptionType.POST_CONSTRUCT, new Annotation[]{new AnnotationLiteral<MessageBinding>(){}, new AnnotationLiteral<LoggedBinding>(){}, new AnnotationLiteral<TransactionalBinding>(){}, new AnnotationLiteral<PingBinding>(){}, new AnnotationLiteral<PongBinding>(){}, new BallBindingLiteral(true, true)}).size(), (int)1);
        Assert.assertEquals((int)this.getCurrentManager().resolveInterceptors(InterceptionType.PRE_DESTROY, new Annotation[]{new AnnotationLiteral<MessageBinding>(){}, new AnnotationLiteral<LoggedBinding>(){}, new AnnotationLiteral<TransactionalBinding>(){}, new AnnotationLiteral<PingBinding>(){}, new AnnotationLiteral<PongBinding>(){}, new BallBindingLiteral(true, true)}).size(), (int)1);
        ComplicatedInterceptor.reset();
        Bean<RemoteMessageService> bean = this.getUniqueBean(RemoteMessageService.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        RemoteMessageService remoteMessageService = (RemoteMessageService)bean.create(ctx);
        remoteMessageService.ping();
        bean.destroy((Object)remoteMessageService, ctx);
        Assert.assertTrue((boolean)ComplicatedInterceptor.postConstructCalled);
        Assert.assertTrue((boolean)ComplicatedInterceptor.preDestroyCalled);
    }
}

