/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.injection.enums;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.NewLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.injection.enums.BasicEnum;
import org.jboss.cdi.tck.tests.lookup.injection.enums.Cat;
import org.jboss.cdi.tck.tests.lookup.injection.enums.Dog;
import org.jboss.cdi.tck.tests.lookup.injection.enums.EnclosingClass;
import org.jboss.cdi.tck.tests.lookup.injection.enums.EnumWithNewInjectionPoint;
import org.jboss.cdi.tck.tests.lookup.injection.enums.VerifyingExtension;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration", "enums"})
@SpecVersion(spec="cdi", version="20091101")
public class EnumInjectionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EnumInjectionTest.class)).withExtension(VerifyingExtension.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.9", id="c"), @SpecAssertion(section="3.9.1", id="aa"), @SpecAssertion(section="3.10", id="c"), @SpecAssertion(section="5.5.2", id="ada"), @SpecAssertion(section="5.5.2", id="adb")})
    public void testBasicEnum() {
        EnumInjectionTest.verifyBasicEnum(BasicEnum.FOO);
        EnumInjectionTest.verifyBasicEnum(BasicEnum.BAR);
        EnumInjectionTest.verifyBasicEnum(BasicEnum.BAZ);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.9", id="c"), @SpecAssertion(section="3.10", id="c"), @SpecAssertion(section="5.5.2", id="ada"), @SpecAssertion(section="5.5.2", id="adb")})
    public void testAdvancedEnum() {
        Assert.assertEquals((int)EnclosingClass.AdvancedEnum.values().length, (int)2);
        for (EnclosingClass.AdvancedEnum item : EnclosingClass.AdvancedEnum.values()) {
            Assert.assertNotNull((Object)item.getSuperclassCat());
            Assert.assertNotNull((Object)item.getSuperclassDog());
            Assert.assertNotNull((Object)item.getInitializerAbstractDog());
            Assert.assertNotNull((Object)item.getSubclassCat());
            Assert.assertNotNull((Object)item.getSubclassDog());
        }
        EnclosingClass.AdvancedEnum.FOO.getSubclassDog().setName("Rex");
        Assert.assertEquals((String)EnclosingClass.AdvancedEnum.BAR.getSuperclassDog().getName(), (String)"Rex");
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    public void testNewBeansCreated(BeanManager manager) {
        Assert.assertNotNull((Object)EnumWithNewInjectionPoint.FOO.getCat());
        Assert.assertNotNull((Object)EnumWithNewInjectionPoint.FOO.getDog());
        Assert.assertEquals((int)manager.getBeans(Cat.class, new Annotation[]{NewLiteral.INSTANCE}).size(), (int)1);
        Assert.assertEquals((int)manager.getBeans(Dog.class, new Annotation[]{NewLiteral.INSTANCE}).size(), (int)1);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    public void testProcessAnnotatedTypeFiredForEnums(VerifyingExtension extension) {
        Assert.assertTrue((boolean)extension.getObservedEnums().contains(BasicEnum.class));
        Assert.assertTrue((boolean)extension.getObservedEnums().contains(EnclosingClass.AdvancedEnum.class));
        Assert.assertTrue((boolean)extension.getObservedEnums().contains(EnumWithNewInjectionPoint.class));
    }

    private static void verifyBasicEnum(BasicEnum e) {
        Assert.assertNotNull((Object)e.getCat());
        Assert.assertNotNull((Object)e.getDog());
        Assert.assertNotNull((Object)e.getCat().getIp());
        Assert.assertNull((Object)e.getCat().getIp().getBean());
    }
}

