/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.impl.testng;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ITestContext;

public class SingleTestClassMethodInterceptor
implements IMethodInterceptor {
    public static final String TEST_CLASS_PROPERTY = "tckTest";
    private final Logger logger = Logger.getLogger(SingleTestClassMethodInterceptor.class.getName());

    public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
        this.logger.log(Level.INFO, "Intercepting... [methods: {0}]", methods.size());
        long start = System.currentTimeMillis();
        String testClass = System.getProperty(TEST_CLASS_PROPERTY);
        if (testClass == null || testClass.isEmpty()) {
            Collections.sort(methods, new Comparator<IMethodInstance>(){

                @Override
                public int compare(IMethodInstance o1, IMethodInstance o2) {
                    int result = o1.getMethod().getTestClass().getName().compareTo(o2.getMethod().getTestClass().getName());
                    return result;
                }
            });
            this.logger.log(Level.INFO, "tckTest not set [time: {1} ms]", System.currentTimeMillis() - start);
            return methods;
        }
        ArrayList<IMethodInstance> ret = new ArrayList<IMethodInstance>();
        if (testClass.contains(".")) {
            for (IMethodInstance method : methods) {
                if (!method.getMethod().getTestClass().getName().equals(testClass)) continue;
                ret.add(method);
            }
        } else {
            for (IMethodInstance method : methods) {
                if (!method.getMethod().getTestClass().getName().endsWith("." + testClass)) continue;
                ret.add(method);
            }
        }
        this.logger.log(Level.INFO, "tckTest set to {0} [methods: {1}, time: {2} ms]", new Object[]{testClass, ret.size(), System.currentTimeMillis() - start});
        return ret;
    }
}

