/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.invocationContext;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.interceptors.tests.invocationContext.Interceptor1;
import org.jboss.cdi.tck.interceptors.tests.invocationContext.Interceptor7;
import org.jboss.cdi.tck.interceptors.tests.invocationContext.Interceptor8;
import org.jboss.cdi.tck.interceptors.tests.invocationContext.Interceptor9;
import org.jboss.cdi.tck.interceptors.tests.invocationContext.LifecycleCallbackInterceptor;
import org.jboss.cdi.tck.interceptors.tests.invocationContext.SimpleBean;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="int", version="3.1.PFD")
public class InvocationContextTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InvocationContextTest.class)).build();
    }

    @Test
    @SpecAssertion(section="6", id="d")
    public void testGetTargetMethod() {
        SimpleBean instance = this.getInstanceByType(SimpleBean.class, new Annotation[0]);
        instance.setId(10);
        assert (instance.getId() == 10);
        assert (Interceptor1.isGetTargetOK());
    }

    @Test
    @SpecAssertion(section="6", id="f")
    public void testGetTimerMethod() {
        assert (this.getInstanceByType(SimpleBean.class, new Annotation[0]).testGetTimer());
    }

    @Test
    @SpecAssertion(section="6", id="g")
    public void testGetMethodForAroundInvokeInterceptorMethod() {
        assert (this.getInstanceByType(SimpleBean.class, new Annotation[0]).testGetMethod());
    }

    @Test
    @SpecAssertion(section="6", id="h")
    public void testGetMethodForLifecycleCallbackInterceptorMethod() {
        this.getInstanceByType(SimpleBean.class, new Annotation[0]);
        assert (LifecycleCallbackInterceptor.isGetMethodReturnsNull());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="6", id="i"), @SpecAssertion(section="6", id="j"), @SpecAssertion(section="6", id="k")})
    public void testMethodParameters() {
        assert (this.getInstanceByType(SimpleBean.class, new Annotation[0]).add(1, 2) == 5);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="6", id="la")
    public void testIllegalNumberOfParameters() {
        this.getInstanceByType(SimpleBean.class, new Annotation[0]).add2(1, 1);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="6", id="lb")
    public void testIllegalTypeOfParameters() {
        assert (this.getInstanceByType(SimpleBean.class, new Annotation[0]).add3(1, 1) == 2);
    }

    @Test
    @SpecAssertion(section="6", id="o")
    public void testProceedReturnsNullForVoidMethod() {
        this.getInstanceByType(SimpleBean.class, new Annotation[0]).voidMethod();
        assert (Interceptor7.isProceedReturnsNull());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="1", id="d"), @SpecAssertion(section="6", id="a")})
    public void testContextData() {
        this.getInstanceByType(SimpleBean.class, new Annotation[0]).foo();
        assert (Interceptor8.isContextDataOK());
        assert (Interceptor9.isContextDataOK());
    }

    @Test
    @SpecAssertion(section="6", id="n")
    public void testBusinessMethodNotCalledWithoutProceedInvocation() {
        assert (this.getInstanceByType(SimpleBean.class, new Annotation[0]).echo("foo").equals("foo"));
        assert (!SimpleBean.isEchoCalled());
    }
}

