/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.lifecycleCallback;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.interceptors.tests.lifecycleCallback.Animal;
import org.jboss.cdi.tck.interceptors.tests.lifecycleCallback.AnimalInterceptor;
import org.jboss.cdi.tck.interceptors.tests.lifecycleCallback.Chicken;
import org.jboss.cdi.tck.interceptors.tests.lifecycleCallback.Cow;
import org.jboss.cdi.tck.interceptors.tests.lifecycleCallback.Goat;
import org.jboss.cdi.tck.interceptors.tests.lifecycleCallback.Hen;
import org.jboss.cdi.tck.interceptors.tests.lifecycleCallback.PackagePrivateLifecycleInterceptor;
import org.jboss.cdi.tck.interceptors.tests.lifecycleCallback.PrivateLifecycleInterceptor;
import org.jboss.cdi.tck.interceptors.tests.lifecycleCallback.ProtectedLifecycleInterceptor;
import org.jboss.cdi.tck.interceptors.tests.lifecycleCallback.PublicLifecycleInterceptor;
import org.jboss.cdi.tck.interceptors.tests.lifecycleCallback.Sheep;
import org.jboss.cdi.tck.interceptors.tests.lifecycleCallback.SheepInterceptor;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="int", version="3.1.PFD")
public class LifecycleCallbackInterceptorTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(LifecycleCallbackInterceptorTest.class)).build();
    }

    @Test
    @SpecAssertion(section="5", id="a")
    public void testPostConstructInterceptor() {
        this.getInstanceByType(Goat.class, new Annotation[0]);
        assert (Goat.isPostConstructInterceptorCalled());
        assert (AnimalInterceptor.isPostConstructInterceptorCalled("Goat"));
        this.getInstanceByType(Hen.class, new Annotation[0]).toString();
        assert (Hen.isPostConstructInterceptorCalled());
        assert (AnimalInterceptor.isPostConstructInterceptorCalled("Hen"));
        this.getInstanceByType(Cow.class, new Annotation[0]).toString();
        assert (Cow.isPostConstructInterceptorCalled());
        assert (AnimalInterceptor.isPostConstructInterceptorCalled("Cow"));
    }

    @Test
    @SpecAssertion(section="5", id="a")
    public void testPreDestroyInterceptor() {
        this.createAndDestroyInstance(Goat.class);
        assert (Goat.isPreDestroyInterceptorCalled());
        assert (AnimalInterceptor.isPreDestroyInterceptorCalled("Goat"));
        this.createAndDestroyInstance(Hen.class);
        assert (Hen.isPreDestroyInterceptorCalled());
        assert (AnimalInterceptor.isPreDestroyInterceptorCalled("Hen"));
        this.createAndDestroyInstance(Cow.class);
        assert (Cow.isPreDestroyInterceptorCalled());
        assert (AnimalInterceptor.isPreDestroyInterceptorCalled("Cow"));
    }

    private <T extends Animal> void createAndDestroyInstance(Class<T> clazz) {
        Bean<T> bean = this.getUniqueBean(clazz, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        Animal instance = (Animal)this.getCurrentManager().getReference(bean, clazz, ctx);
        instance.foo();
        bean.destroy((Object)instance, ctx);
    }

    @Test
    @SpecAssertion(section="5", id="c")
    public void testAroundInvokeAndLifeCycleCallbackInterceptorsCanBeDefinedOnTheSameClass() {
        assert (this.getInstanceByType(Goat.class, new Annotation[0]).echo("foo").equals("foofoo"));
    }

    @Test
    @SpecAssertion(section="5", id="j")
    public void testPublicLifecycleInterceptorMethod() {
        this.getInstanceByType(Chicken.class, new Annotation[0]);
        assert (PublicLifecycleInterceptor.isIntercepted());
    }

    @Test
    @SpecAssertion(section="5", id="k")
    public void testProtectedLifecycleInterceptorMethod() {
        this.getInstanceByType(Chicken.class, new Annotation[0]);
        assert (ProtectedLifecycleInterceptor.isIntercepted());
    }

    @Test
    @SpecAssertion(section="5", id="l")
    public void testPrivateLifecycleInterceptorMethod() {
        this.getInstanceByType(Chicken.class, new Annotation[0]);
        assert (PrivateLifecycleInterceptor.isIntercepted());
    }

    @Test
    @SpecAssertion(section="5", id="m")
    public void testPackagePrivateLifecycleInterceptorMethod() {
        this.getInstanceByType(Chicken.class, new Annotation[0]);
        assert (PackagePrivateLifecycleInterceptor.isIntercepted());
    }

    @Test
    @SpecAssertion(section="8", id="c")
    public void testLifeCycleCallbackInterceptorNotInvokedForMethodLevelInterceptor() {
        assert (this.getInstanceByType(Sheep.class, new Annotation[0]).foo().equals("bar"));
        assert (SheepInterceptor.isAroundInvokeCalled());
        assert (!SheepInterceptor.isPostConstructCalled());
    }
}

