/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.method;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.interceptors.tests.method.Dog;
import org.jboss.cdi.tck.interceptors.tests.method.Fish;
import org.jboss.cdi.tck.interceptors.tests.method.FishInterceptor;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="int", version="3.1.PFD")
public class MethodLevelInterceptorTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(MethodLevelInterceptorTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3", id="ca"), @SpecAssertion(section="8", id="a"), @SpecAssertion(section="8", id="d"), @SpecAssertion(section="8", id="g"), @SpecAssertion(section="8", id="h")})
    public void testInterceptorCanBeAppliedToMoreThanOneMethod() {
        Fish fish = this.getInstanceByType(Fish.class, new Annotation[0]);
        assert (fish.foo().equals("Intercepted bar"));
        assert (fish.ping().equals("Intercepted pong"));
        assert (fish.getName().equals("Salmon"));
        assert (FishInterceptor.getInstanceCount() == 1);
    }

    @Test
    @SpecAssertion(section="8", id="j")
    public void testExcludeClassInterceptors() {
        assert (this.getInstanceByType(Dog.class, new Annotation[0]).foo().equals("Intercepted bar"));
        assert (this.getInstanceByType(Dog.class, new Annotation[0]).ping().equals("pong"));
    }
}

