/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.application.disposer;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.application.disposer.Edible;
import org.jboss.cdi.tck.tests.context.application.disposer.Forest;
import org.jboss.cdi.tck.tests.context.application.disposer.Mushroom;
import org.jboss.cdi.tck.util.SimpleLogger;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class ApplicationContextDisposerTest
extends AbstractTest {
    private static final SimpleLogger logger = new SimpleLogger(ApplicationContextDisposerTest.class);
    @Inject
    Forest forest;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ApplicationContextDisposerTest.class)).build();
    }

    @Test
    @SpecAssertion(section="6.7.3", id="dg")
    public void testApplicationContextActiveDuringDispose() {
        logger.log("Injected forest: {0}", this.forest.toString());
        Bean<Mushroom> bean = this.getUniqueBean(Mushroom.class, new Annotation[]{new AnnotationLiteral<Edible>(){}});
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        Mushroom mushroom = (Mushroom)bean.create(ctx);
        Assert.assertEquals((String)mushroom.getName(), (String)"Boletus");
        Assert.assertFalse((boolean)this.forest.isEmpty());
        bean.destroy((Object)mushroom, ctx);
        Assert.assertTrue((boolean)this.forest.isEmpty());
    }
}

