/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.application.ejb;

import java.lang.annotation.Annotation;
import java.util.concurrent.Future;
import javax.ejb.EJB;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.EnterpriseArchiveBuilder;
import org.jboss.cdi.tck.tests.context.application.ejb.BarBean;
import org.jboss.cdi.tck.tests.context.application.ejb.FMS;
import org.jboss.cdi.tck.tests.context.application.ejb.FMSModelIII;
import org.jboss.cdi.tck.tests.context.application.ejb.FooBean;
import org.jboss.cdi.tck.tests.context.application.ejb.FooRemote;
import org.jboss.cdi.tck.tests.context.application.ejb.SimpleApplicationBean;
import org.jboss.cdi.tck.util.Timer;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"javaee-full", "contexts"})
@SpecVersion(spec="cdi", version="20091101")
public class ApplicationContextSharedTest
extends AbstractTest {
    @EJB
    BarBean bar;
    @EJB(lookup="java:global/test-ejb/test-ejb/FooBean!org.jboss.cdi.tck.tests.context.application.ejb.FooRemote")
    FooRemote foo;

    @Deployment(name="TEST", order=1)
    public static EnterpriseArchive createTestArchive() {
        return (EnterpriseArchive)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)new EnterpriseArchiveBuilder().withTestClass(ApplicationContextSharedTest.class)).withClasses(BarBean.class, FMS.class, FMSModelIII.class, SimpleApplicationBean.class, FooRemote.class)).build();
    }

    @Deployment(name="REMOTE_EJB", order=2, testable=false)
    public static EnterpriseArchive createEjbArchive() {
        return (EnterpriseArchive)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)new EnterpriseArchiveBuilder().notTestArchive()).noDefaultWebModule().withName("test-ejb.ear")).withEjbModuleName("test-ejb.jar").withClasses(FooBean.class, FooRemote.class, SimpleApplicationBean.class)).build();
    }

    @OperateOnDeployment(value="TEST")
    @Test
    @SpecAssertion(section="6.7.3", id="e")
    public void testApplicationContextShared() throws Exception {
        FMSModelIII.reset();
        FMS flightManagementSystem = this.getInstanceByType(FMS.class, new Annotation[0]);
        flightManagementSystem.climb();
        Timer timer = new Timer().setDelay(20000L).addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return FMSModelIII.isClimbed();
            }
        }).start();
        flightManagementSystem.descend();
        timer.addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return FMSModelIII.isDescended();
            }
        }, true).start();
        Assert.assertTrue((boolean)flightManagementSystem.isSameBean());
    }

    @OperateOnDeployment(value="TEST")
    @Test
    @SpecAssertion(section="6.7.3", id="dc")
    public void testApplicationScopeActiveDuringCallToEjbTimeoutMethod() throws Exception {
        FMS flightManagementSystem = this.getInstanceByType(FMS.class, new Annotation[0]);
        flightManagementSystem.climb();
        new Timer().setDelay(20000L).addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return FMSModelIII.isClimbed();
            }
        }).start();
        Assert.assertTrue((boolean)flightManagementSystem.isApplicationScopeActive());
    }

    @OperateOnDeployment(value="TEST")
    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="6.7.3", id="db")})
    public void testApplicationScopeActiveDuringAsyncCallToEjb(SimpleApplicationBean simpleApplicationBean) throws Exception {
        Future<Double> result = this.bar.compute();
        Double id = result.get();
        Assert.assertNotEquals((Object)id, (Object)-1.0);
        Assert.assertEquals((Object)id, (Object)simpleApplicationBean.getId());
    }

    @OperateOnDeployment(value="TEST")
    @Test
    @SpecAssertion(section="6.7.3", id="da")
    public void testApplicationScopeActiveDuringRemoteCallToEjb() {
        Assert.assertNotNull((Object)this.foo.ping());
    }
}

