/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.dependent;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.impl.MockCreationalContext;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.dependent.AccountTransaction;
import org.jboss.cdi.tck.tests.context.dependent.DomesticationKit;
import org.jboss.cdi.tck.tests.context.dependent.Farm;
import org.jboss.cdi.tck.tests.context.dependent.Fox;
import org.jboss.cdi.tck.tests.context.dependent.FoxFarm;
import org.jboss.cdi.tck.tests.context.dependent.FoxHole;
import org.jboss.cdi.tck.tests.context.dependent.FoxRun;
import org.jboss.cdi.tck.tests.context.dependent.Horse;
import org.jboss.cdi.tck.tests.context.dependent.HorseInStableEvent;
import org.jboss.cdi.tck.tests.context.dependent.HorseStable;
import org.jboss.cdi.tck.tests.context.dependent.Interior;
import org.jboss.cdi.tck.tests.context.dependent.InteriorDecorator;
import org.jboss.cdi.tck.tests.context.dependent.OtherSpiderProducer;
import org.jboss.cdi.tck.tests.context.dependent.Pet;
import org.jboss.cdi.tck.tests.context.dependent.RoomBinding;
import org.jboss.cdi.tck.tests.context.dependent.SensitiveFox;
import org.jboss.cdi.tck.tests.context.dependent.SpiderProducer;
import org.jboss.cdi.tck.tests.context.dependent.Stable;
import org.jboss.cdi.tck.tests.context.dependent.Tame;
import org.jboss.cdi.tck.tests.context.dependent.Tarantula;
import org.jboss.cdi.tck.tests.context.dependent.TransactionalInterceptor;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class DependentContextTest
extends AbstractTest {
    private static final Annotation TAME_LITERAL = new AnnotationLiteral<Tame>(){};
    private static final Annotation PET_LITERAL = new AnnotationLiteral<Pet>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(DependentContextTest.class)).withBeansXml("beans.xml")).build();
    }

    @Test(groups={"contexts", "injection"})
    @SpecAssertions(value={@SpecAssertion(section="6.4", id="a"), @SpecAssertion(section="6.4.1", id="ga")})
    public void testInstanceNotSharedBetweenInjectionPoints() {
        Set<Bean<Fox>> foxBeans = this.getBeans(Fox.class, new Annotation[0]);
        assert (foxBeans.size() == 1);
        Set<Bean<FoxRun>> foxRunBeans = this.getBeans(FoxRun.class, new Annotation[0]);
        assert (foxRunBeans.size() == 1);
        Bean<FoxRun> foxRunBean = foxRunBeans.iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(foxRunBean);
        FoxRun foxRun = (FoxRun)foxRunBean.create(creationalContext);
        assert (!foxRun.fox.equals(foxRun.anotherFox));
        assert (!foxRun.fox.equals(foxRun.petFox));
        assert (!foxRun.anotherFox.equals(foxRun.petFox));
    }

    @Test(groups={"contexts", "injection"})
    @SpecAssertions(value={@SpecAssertion(section="6.4.1", id="ga"), @SpecAssertion(section="6.4.1", id="gb"), @SpecAssertion(section="6.4.1", id="gc")})
    public void testDependentBeanIsDependentObjectOfBeanInjectedInto() {
        FoxFarm foxFarm = this.getInstanceByType(FoxFarm.class, new Annotation[0]);
        FoxHole foxHole = this.getInstanceByType(FoxHole.class, new Annotation[0]);
        assert (!foxFarm.fox.equals(foxHole.fox));
        assert (!foxFarm.fox.equals(foxFarm.constructorFox));
        assert (!foxFarm.constructorFox.equals(foxHole.initializerFox));
        assert (!foxHole.fox.equals(foxHole.initializerFox));
    }

    @Test(groups={"contexts", "el"})
    @SpecAssertion(section="6.4", id="ca")
    public void testInstanceUsedForElEvaluationNotShared() throws Exception {
        Set<Bean<Fox>> foxBeans = this.getBeans(Fox.class, new Annotation[0]);
        assert (foxBeans.size() == 1);
        Fox fox1 = (Fox)this.getCurrentConfiguration().getEl().evaluateValueExpression(this.getCurrentManager(), "#{fox}", Fox.class);
        Fox fox2 = (Fox)this.getCurrentConfiguration().getEl().evaluateValueExpression(this.getCurrentManager(), "#{fox}", Fox.class);
        assert (!fox1.equals(fox2));
    }

    @Test(groups={"contexts", "producerMethod"})
    @SpecAssertion(section="6.4", id="da")
    public void testInstanceUsedForProducerMethodNotShared() throws Exception {
        SpiderProducer.reset();
        this.getInstanceByType(Tarantula.class, PET_LITERAL);
        Integer firstInstanceHash = SpiderProducer.getInstanceUsedForProducerHashcode();
        SpiderProducer.reset();
        this.getInstanceByType(Tarantula.class, PET_LITERAL);
        Integer secondInstanceHash = SpiderProducer.getInstanceUsedForProducerHashcode();
        Assert.assertFalse((boolean)firstInstanceHash.equals(secondInstanceHash));
    }

    @Test(groups={"contexts", "producerMethod"})
    @SpecAssertion(section="6.4", id="db")
    public void testInstanceUsedForProducerFieldNotShared() throws Exception {
        Tarantula firstIntance = this.getInstanceByType(Tarantula.class, TAME_LITERAL);
        Tarantula secondIntance = this.getInstanceByType(Tarantula.class, TAME_LITERAL);
        Assert.assertNotNull((Object)firstIntance.getProducerInstanceHashcode());
        Assert.assertNotNull((Object)secondIntance.getProducerInstanceHashcode());
        Assert.assertNotEquals((Object)firstIntance.getProducerInstanceHashcode(), (Object)secondIntance.getProducerInstanceHashcode());
    }

    @Test(groups={"contexts", "disposal"})
    @SpecAssertions(value={@SpecAssertion(section="6.4", id="dc"), @SpecAssertion(section="6.4", id="dg")})
    public void testInstanceUsedForDisposalMethodNotShared() {
        Integer firstFoxHash = this.getInstanceByType(Fox.class, new Annotation[0]).hashCode();
        SpiderProducer.reset();
        SpiderProducer spiderProducer = this.getInstanceByType(SpiderProducer.class, new Annotation[0]);
        Bean<Tarantula> tarantulaBean = this.getUniqueBean(Tarantula.class, PET_LITERAL);
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(tarantulaBean);
        Tarantula tarantula = (Tarantula)tarantulaBean.create(creationalContext);
        assert (tarantula != null);
        tarantulaBean.destroy((Object)tarantula, creationalContext);
        Integer secondFoxHash = SpiderProducer.getFoxUsedForDisposalHashcode();
        assert (SpiderProducer.getInstanceUsedForDisposalHashcode() != null);
        assert (!SpiderProducer.getInstanceUsedForDisposalHashcode().equals(spiderProducer.hashCode()));
        CreationalContext nextCreationalContext = this.getCurrentManager().createCreationalContext(tarantulaBean);
        Tarantula nextTarantula = (Tarantula)tarantulaBean.create(nextCreationalContext);
        assert (nextTarantula != null);
        tarantulaBean.destroy((Object)nextTarantula, creationalContext);
        Integer thirdFoxHash = SpiderProducer.getFoxUsedForDisposalHashcode();
        Assert.assertNotEquals((Object)firstFoxHash, (Object)secondFoxHash);
        Assert.assertNotEquals((Object)firstFoxHash, (Object)thirdFoxHash);
        Assert.assertNotEquals((Object)thirdFoxHash, (Object)secondFoxHash);
        SpiderProducer.reset();
    }

    @Test(groups={"contexts", "observerMethod"})
    @SpecAssertions(value={@SpecAssertion(section="6.4", id="dd"), @SpecAssertion(section="6.4", id="dg")})
    public void testInstanceUsedForObserverMethodNotShared() {
        HorseStable.reset();
        HorseStable firstStableInstance = this.getInstanceByType(HorseStable.class, new Annotation[0]);
        this.getCurrentManager().fireEvent((Object)new HorseInStableEvent(), new Annotation[0]);
        Integer firstFoxHash = HorseStable.getFoxUsedForObservedEventHashcode();
        Integer firstObserverHash = HorseStable.getInstanceThatObservedEventHashcode();
        this.getCurrentManager().fireEvent((Object)new HorseInStableEvent(), new Annotation[0]);
        Integer secondFoxHash = HorseStable.getFoxUsedForObservedEventHashcode();
        Integer secondObserverHash = HorseStable.getInstanceThatObservedEventHashcode();
        Assert.assertNotNull((Object)firstObserverHash);
        Assert.assertNotNull((Object)secondObserverHash);
        Assert.assertNotNull((Object)firstFoxHash);
        Assert.assertNotNull((Object)secondFoxHash);
        Assert.assertNotEquals((Object)firstStableInstance.hashCode(), (Object)firstObserverHash);
        Assert.assertNotEquals((Object)firstStableInstance.hashCode(), (Object)secondObserverHash);
        Assert.assertNotEquals((Object)firstObserverHash, (Object)secondObserverHash);
        Assert.assertNotEquals((Object)firstFoxHash, (Object)secondFoxHash);
    }

    @Test(groups={"contexts"})
    @SpecAssertion(section="6.4", id="e")
    public void testContextGetWithCreationalContextReturnsNewInstance() {
        Set<Bean<Fox>> foxBeans = this.getBeans(Fox.class, new Annotation[0]);
        assert (foxBeans.size() == 1);
        Bean<Fox> foxBean = foxBeans.iterator().next();
        Context context = this.getCurrentManager().getContext(Dependent.class);
        assert (context.get(foxBean, new MockCreationalContext()) != null);
        assert (context.get(foxBean, new MockCreationalContext()) instanceof Fox);
    }

    @Test(groups={"contexts"})
    @SpecAssertion(section="6.4", id="f")
    public void testContextGetWithCreateFalseReturnsNull() {
        Set<Bean<Fox>> foxBeans = this.getBeans(Fox.class, new Annotation[0]);
        assert (foxBeans.size() == 1);
        Bean<Fox> foxBean = foxBeans.iterator().next();
        Context context = this.getCurrentManager().getContext(Dependent.class);
        assert (context.get(foxBean, null) == null);
    }

    @Test(groups={"contexts"})
    @SpecAssertion(section="6.2", id="ab")
    public void testContextScopeType() {
        assert (this.getCurrentManager().getContext(Dependent.class).getScope().equals(Dependent.class));
    }

    @Test(groups={"contexts"})
    @SpecAssertions(value={@SpecAssertion(section="6.2", id="ha"), @SpecAssertion(section="6.4", id="g")})
    public void testContextIsActive() {
        assert (this.getCurrentManager().getContext(Dependent.class).isActive());
    }

    @Test(groups={"contexts", "producerMethod"})
    @SpecAssertions(value={@SpecAssertion(section="6.2", id="ha"), @SpecAssertion(section="6.4", id="g")})
    public void testContextIsActiveWhenInvokingProducerMethod() {
        SpiderProducer.reset();
        Tarantula tarantula = this.getInstanceByType(Tarantula.class, PET_LITERAL);
        assert (tarantula != null);
        assert (SpiderProducer.isDependentContextActive());
        SpiderProducer.reset();
    }

    @Test(groups={"contexts", "producerField"})
    @SpecAssertion(section="6.4", id="g")
    public void testContextIsActiveWhenInvokingProducerField() {
        Tarantula.reset();
        this.getInstanceByType(Tarantula.class, TAME_LITERAL);
        assert (Tarantula.isDependentContextActive());
        SpiderProducer.reset();
    }

    @Test(groups={"contexts", "disposal"})
    @SpecAssertions(value={@SpecAssertion(section="6.4", id="g"), @SpecAssertion(section="11.1", id="aa")})
    public void testContextIsActiveWhenInvokingDisposalMethod() {
        Bean<Tarantula> tarantulaBean = this.getBeans(Tarantula.class, PET_LITERAL).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(tarantulaBean);
        Tarantula tarantula = (Tarantula)tarantulaBean.create(creationalContext);
        assert (tarantula != null);
        SpiderProducer.reset();
        tarantulaBean.destroy((Object)tarantula, creationalContext);
        assert (SpiderProducer.isDependentContextActive());
        SpiderProducer.reset();
    }

    @Test(groups={"contexts", "observerMethod"})
    @SpecAssertion(section="6.4", id="g")
    public void testContextIsActiveWhenCreatingObserverMethodInstance() {
        this.getCurrentManager().fireEvent((Object)new HorseInStableEvent(), new Annotation[0]);
        assert (HorseStable.isDependentContextActive());
    }

    @Test(groups={"contexts", "el"})
    @SpecAssertion(section="6.4", id="g")
    public void testContextIsActiveWhenEvaluatingElExpression() {
        String foxName = (String)this.getCurrentConfiguration().getEl().evaluateMethodExpression(this.getCurrentManager(), "#{sensitiveFox.getName}", String.class, new Class[0], new Object[0]);
        assert (foxName != null);
        assert (SensitiveFox.isDependentContextActiveDuringEval());
    }

    @Test(groups={"contexts", "lifecycle"})
    @SpecAssertion(section="6.4", id="g")
    public void testContextIsActiveDuringBeanCreation() {
        SensitiveFox fox1 = this.getInstanceByType(SensitiveFox.class, new Annotation[0]);
        assert (fox1 != null);
        assert (fox1.isDependentContextActiveDuringCreate());
    }

    @Test(groups={"contexts", "injection"})
    @SpecAssertion(section="6.4", id="g")
    public void testContextIsActiveDuringInjection() {
        Bean<FoxRun> foxRunBean = this.getBeans(FoxRun.class, new Annotation[0]).iterator().next();
        FoxRun foxRun = (FoxRun)foxRunBean.create(new MockCreationalContext());
        assert (foxRun.fox != null);
    }

    @Test(groups={"contexts", "lifecycle"})
    @SpecAssertions(value={@SpecAssertion(section="6.4.2", id="aaaa"), @SpecAssertion(section="6.4", id="b")})
    public void testDestroyingSimpleParentDestroysDependents() {
        assert (this.getBeans(Farm.class, new Annotation[0]).size() == 1);
        Bean<Farm> farmBean = this.getBeans(Farm.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(farmBean);
        Farm farm = (Farm)farmBean.create(creationalContext);
        farm.open();
        Stable.destroyed = false;
        Horse.destroyed = false;
        farmBean.destroy((Object)farm, creationalContext);
        assert (Stable.destroyed);
        assert (Horse.destroyed);
    }

    @Test(groups={"contexts", "lifecycle"})
    @SpecAssertions(value={@SpecAssertion(section="6.1.1", id="e")})
    public void testCallingCreationalContextReleaseDestroysDependents() {
        assert (this.getBeans(Farm.class, new Annotation[0]).size() == 1);
        Bean<Farm> farmBean = this.getBeans(Farm.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(farmBean);
        Farm farm = (Farm)farmBean.create(creationalContext);
        farm.open();
        Stable.destroyed = false;
        Horse.destroyed = false;
        creationalContext.release();
        assert (Stable.destroyed);
        assert (Horse.destroyed);
        creationalContext = this.getCurrentManager().createCreationalContext(farmBean);
        farm = (Farm)this.getCurrentManager().getReference(farmBean, Farm.class, creationalContext);
        farm.open();
        Stable.destroyed = false;
        Horse.destroyed = false;
        creationalContext.release();
        assert (Stable.destroyed);
        assert (Horse.destroyed);
    }

    @Test(groups={"contexts", "lifecycle"})
    @SpecAssertions(value={@SpecAssertion(section="6.4.2", id="aaaa"), @SpecAssertion(section="6.4", id="b")})
    public void testDestroyingManagedParentDestroysDependentsOfSameBean() {
        Fox.reset();
        assert (this.getCurrentManager().getBeans(FoxRun.class, new Annotation[0]).size() == 1);
        Bean<FoxRun> bean = this.getBeans(FoxRun.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(bean);
        FoxRun instance = (FoxRun)bean.create(creationalContext);
        assert (instance.fox != instance.anotherFox);
        bean.destroy((Object)instance, creationalContext);
        assert (Fox.isDestroyed());
        assert (Fox.getDestroyCount() == 2);
    }

    @Test(groups={"contexts", "el"})
    @SpecAssertion(section="6.4.2", id="eee")
    public void testDependentsDestroyedWhenElEvaluationCompletes() throws Exception {
        Fox.reset();
        FoxRun.setDestroyed(false);
        this.getCurrentConfiguration().getEl().evaluateValueExpression(this.getCurrentManager(), "#{foxRun}", FoxRun.class);
        assert (FoxRun.isDestroyed());
        assert (Fox.isDestroyed());
    }

    @Test(groups={"contexts", "producerMethod"})
    @SpecAssertions(value={@SpecAssertion(section="6.4.2", id="ddd"), @SpecAssertion(section="6.4.1", id="h"), @SpecAssertion(section="5.5.4", id="f")})
    public void testDependentsDestroyedWhenProducerMethodCompletes() {
        SpiderProducer.reset();
        Tarantula.reset();
        DomesticationKit.reset();
        Bean<Tarantula> tarantulaBean = this.getUniqueBean(Tarantula.class, PET_LITERAL);
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(tarantulaBean);
        Tarantula tarantula = (Tarantula)this.getCurrentManager().getReference(tarantulaBean, Tarantula.class, creationalContext);
        tarantula.ping();
        assert (SpiderProducer.isDestroyed());
        tarantulaBean.destroy((Object)tarantula, creationalContext);
        assert (DomesticationKit.isDestroyed());
        SpiderProducer.reset();
    }

    @Test(groups={"contexts", "producerField"})
    @SpecAssertion(section="6.4.2", id="dde")
    public void testDependentsDestroyedWhenProducerFieldCompletes() {
        OtherSpiderProducer.setDestroyed(false);
        Tarantula spiderInstance = this.getInstanceByType(Tarantula.class, TAME_LITERAL);
        assert (spiderInstance != null);
        assert (OtherSpiderProducer.isDestroyed());
    }

    @Test(groups={"contexts", "disposal"})
    @SpecAssertions(value={@SpecAssertion(section="6.4.2", id="ddf"), @SpecAssertion(section="6.4.2", id="ccc"), @SpecAssertion(section="5.5.4", id="d"), @SpecAssertion(section="5.5.4", id="f")})
    public void testDependentsDestroyedWhenDisposerMethodCompletes() {
        Bean<Tarantula> tarantulaBean = this.getBeans(Tarantula.class, PET_LITERAL).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(tarantulaBean);
        Tarantula tarantula = (Tarantula)tarantulaBean.create(creationalContext);
        Assert.assertNotNull((Object)tarantula);
        SpiderProducer.reset();
        Fox.reset();
        tarantulaBean.destroy((Object)tarantula, creationalContext);
        Assert.assertTrue((boolean)SpiderProducer.isDestroyed());
        Assert.assertNotNull((Object)SpiderProducer.getFoxUsedForDisposalHashcode());
        Assert.assertTrue((boolean)Fox.isDestroyed());
        SpiderProducer.reset();
        Fox.reset();
    }

    @Test(groups={"contexts", "observerMethod"})
    @SpecAssertions(value={@SpecAssertion(section="6.4.2", id="ddg"), @SpecAssertion(section="6.4.2", id="ccd"), @SpecAssertion(section="5.5.6", id="d")})
    public void testDependentsDestroyedWhenObserverMethodEvaluationCompletes() {
        HorseStable.reset();
        Fox.reset();
        this.getCurrentManager().fireEvent((Object)new HorseInStableEvent(), new Annotation[0]);
        assert (HorseStable.getInstanceThatObservedEventHashcode() != null);
        assert (HorseStable.isDestroyed());
        assert (Fox.isDestroyed());
    }

    @Test(groups={"contexts"})
    @SpecAssertion(section="6.4.1", id="ab")
    public void testDependentScopedDecoratorsAreDependentObjectsOfBean() {
        Bean<Interior> roomBean = this.getBeans(Interior.class, new RoomBinding()).iterator().next();
        CreationalContext roomCreationalContext = this.getCurrentManager().createCreationalContext(roomBean);
        Interior room = (Interior)this.getCurrentManager().getReference(roomBean, Interior.class, roomCreationalContext);
        InteriorDecorator.reset();
        room.foo();
        assert (InteriorDecorator.getInstances().size() == 1);
        roomCreationalContext.release();
        assert (InteriorDecorator.isDestroyed());
    }

    @Test
    @SpecAssertion(section="6.4.1", id="aa")
    public void testDependentScopedInterceptorsAreDependentObjectsOfBean() {
        TransactionalInterceptor.destroyed = false;
        TransactionalInterceptor.intercepted = false;
        Bean<AccountTransaction> bean = this.getBeans(AccountTransaction.class, new Annotation[0]).iterator().next();
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        AccountTransaction trans = (AccountTransaction)this.getCurrentManager().getReference(bean, AccountTransaction.class, ctx);
        trans.execute();
        assert (TransactionalInterceptor.intercepted);
        ctx.release();
        assert (TransactionalInterceptor.destroyed);
    }
}

