/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.passivating;

import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.IllegalProductException;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.passivating.City;
import org.jboss.cdi.tck.tests.context.passivating.HelsinkiNonSerializable;
import org.jboss.cdi.tck.tests.context.passivating.Joensuu;
import org.jboss.cdi.tck.tests.context.passivating.Jyvaskyla;
import org.jboss.cdi.tck.tests.context.passivating.Kajaani;
import org.jboss.cdi.tck.tests.context.passivating.Kokkola;
import org.jboss.cdi.tck.tests.context.passivating.NumberConsumer;
import org.jboss.cdi.tck.tests.context.passivating.Record;
import org.jboss.cdi.tck.tests.context.passivating.SerializableCityConsumer;
import org.jboss.cdi.tck.tests.context.passivating.Television;
import org.jboss.cdi.tck.tests.context.passivating.Wheat;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class PassivatingContextTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(PassivatingContextTest.class)).build();
    }

    @Test(groups={"contexts", "passivation"})
    @SpecAssertions(value={@SpecAssertion(section="6.6.1", id="ba"), @SpecAssertion(section="6.6.3", id="a")})
    public void testManagedBeanWithSerializableImplementationClassOK() {
        Set<Bean<Jyvaskyla>> beans = this.getBeans(Jyvaskyla.class, new Annotation[0]);
        assert (!beans.isEmpty());
    }

    @Test(groups={"contexts", "passivation"})
    @SpecAssertion(section="6.6.1", id="bb")
    public void testManagedBeanWithSerializableInterceptorClassOK() {
        Set<Bean<Kokkola>> beans = this.getBeans(Kokkola.class, new Annotation[0]);
        assert (!beans.isEmpty());
    }

    @Test(groups={"contexts", "passivation"})
    @SpecAssertion(section="6.6.1", id="bc")
    public void testManagedBeanWithSerializableDecoratorOK() {
        Set<Bean<City>> beans = this.getBeans(City.class, new Annotation[0]);
        assert (!beans.isEmpty());
    }

    @Test(groups={"contexts", "passivation"})
    @SpecAssertion(section="6.6.1", id="ca")
    public void testPassivationCapableProducerMethodIsOK() {
        Set<Bean<Record>> beans = this.getBeans(Record.class, new Annotation[0]);
        assert (!beans.isEmpty());
    }

    @Test(groups={"contexts", "passivation"})
    @SpecAssertion(section="6.6.1", id="da")
    public void testPassivationCapableProducerFieldIsOK() {
        Set<Bean<Wheat>> beans = this.getBeans(Wheat.class, new Annotation[0]);
        assert (!beans.isEmpty());
    }

    @Test(groups={"contexts", "passivation"})
    @SpecAssertion(section="6.6.2", id="c")
    public void testInjectionOfDependentPrimitiveProductIntoNormalBean() {
        this.getInstanceByType(NumberConsumer.class, new Annotation[0]).ping();
    }

    @Test
    @SpecAssertion(section="6.6.2", id="c")
    public void testInjectionOfDependentSerializableProductIntoNormalBean() {
        this.getInstanceByType(SerializableCityConsumer.class, new Annotation[0]).ping();
    }

    @Test(groups={"contexts", "passivation"})
    @SpecAssertions(value={@SpecAssertion(section="6.6", id="a")})
    public void testPassivationOccurs() throws IOException, ClassNotFoundException {
        Kajaani instance = this.getInstanceByType(Kajaani.class, new Annotation[0]);
        instance.setTheNumber(100);
        Context sessionContext = this.getCurrentManager().getContext(SessionScoped.class);
        this.setContextInactive(sessionContext);
        this.setContextActive(sessionContext);
        instance = this.getInstanceByType(Kajaani.class, new Annotation[0]);
        assert (instance.getTheNumber() == 100);
    }

    @Test(groups={"contexts", "passivation"})
    @SpecAssertion(section="6.6.4", id="aa")
    public void testBeanWithNonSerializableImplementationInjectedIntoTransientFieldOK() {
        Set<Bean<Joensuu>> beans = this.getBeans(Joensuu.class, new Annotation[0]);
        assert (!beans.isEmpty());
    }

    @Test(groups={"contexts", "passivation"}, expectedExceptions={IllegalProductException.class})
    @SpecAssertion(section="6.6.4", id="ea")
    public void testPassivatingScopeProducerMethodReturnsUnserializableObjectNotOk() {
        this.getInstanceByType(Television.class, new Annotation[0]).turnOn();
    }

    @Test(groups={"contexts", "passivation"}, expectedExceptions={IllegalProductException.class})
    @SpecAssertion(section="6.6.4", id="eb")
    public void testNonSerializableProducerFieldDeclaredPassivatingThrowsIllegalProductException() {
        this.getInstanceByType(HelsinkiNonSerializable.class, new Annotation[0]).ping();
    }

    public static boolean isSerializable(Class<?> clazz) {
        return clazz.isPrimitive() || Serializable.class.isAssignableFrom(clazz);
    }
}

