/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request.jaxrs;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class RequestContextTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(RequestContextTest.class)).withWebXml((WebAppDescriptor)((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).createServletMapping().servletName("javax.ws.rs.core.Application").urlPattern(new String[]{"/resources/*"}).up())).build();
    }

    @Test(groups={"contexts"})
    @SpecAssertions(value={@SpecAssertion(section="6.7.1", id="c"), @SpecAssertion(section="6.7.1", id="d"), @SpecAssertion(section="6.7.1", id="jb")})
    public void testRequestScopeActiveDuringWebServiceInvocation() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage resource01 = (TextPage)webClient.getPage(this.contextPath + "resources/foo");
        Long id01 = Long.valueOf(resource01.getContent());
        TextPage resource02 = (TextPage)webClient.getPage(this.contextPath + "resources/foo");
        Long id02 = Long.valueOf(resource02.getContent());
        Assert.assertNotEquals((Object)id01, (Object)id02);
        TextPage resource03 = (TextPage)webClient.getPage(this.contextPath + "info");
        Assert.assertTrue((boolean)resource03.getContent().contains("Initialized requests:3"));
        Assert.assertTrue((boolean)resource03.getContent().contains("Destroyed requests:2"));
        Assert.assertTrue((boolean)resource03.getContent().contains("Foo destroyed:2"));
    }
}

