/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.decorators.builtin.http.request;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.enterprise.inject.spi.Decorator;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.decorators.AbstractDecoratorTest;
import org.jboss.cdi.tck.tests.decorators.builtin.http.request.HttpServletRequestDecorator1;
import org.jboss.cdi.tck.tests.decorators.builtin.http.request.HttpServletRequestDecorator2;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class BuiltinHttpServletRequestDecoratorTest
extends AbstractDecoratorTest {
    @Inject
    HttpServletRequest httpServletRequest;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BuiltinHttpServletRequestDecoratorTest.class)).withClass(AbstractDecoratorTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createDecorators().clazz(new String[]{HttpServletRequestDecorator1.class.getName()}).clazz(new String[]{HttpServletRequestDecorator2.class.getName()}).up())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.4", id="aci")})
    public void testDecoratorIsResolved() {
        List decorators = this.getCurrentManager().resolveDecorators(Collections.singleton(HttpServletRequest.class), new Annotation[0]);
        Assert.assertEquals((int)2, (int)decorators.size());
        for (Decorator decorator : decorators) {
            Assert.assertEquals((Set)decorator.getDecoratedTypes(), new HashSet<Class>(Arrays.asList(HttpServletRequest.class, ServletRequest.class)));
            Assert.assertEquals((Object)decorator.getDelegateType(), HttpServletRequest.class);
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.4", id="aci")})
    public void testDecoratorIsInvoked() {
        Assert.assertNull((Object)this.httpServletRequest.getSession());
        Assert.assertEquals((Object)this.httpServletRequest.getLocale(), (Object)Locale.SIMPLIFIED_CHINESE);
        Assert.assertNull((Object)this.httpServletRequest.getCookies());
        Assert.assertFalse((boolean)this.httpServletRequest.isUserInRole("Blabla"));
    }
}

