/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.definition.name;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.AnyLiteral;
import org.jboss.cdi.tck.literals.DefaultLiteral;
import org.jboss.cdi.tck.literals.NamedLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.definition.name.Haddock;
import org.jboss.cdi.tck.tests.definition.name.Minnow;
import org.jboss.cdi.tck.tests.definition.name.Moose;
import org.jboss.cdi.tck.tests.definition.name.RedSnapper;
import org.jboss.cdi.tck.tests.definition.name.SeaBass;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class NameDefinitionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(NameDefinitionTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.5.1", id="a"), @SpecAssertion(section="2", id="e"), @SpecAssertion(section="3.1.3", id="bb")})
    public void testNonDefaultNamed() {
        Bean<Moose> moose = this.getUniqueBean(Moose.class, new Annotation[0]);
        Assert.assertEquals((String)moose.getName(), (String)"aMoose");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.5.2", id="a"), @SpecAssertion(section="3.1.5", id="a"), @SpecAssertion(section="2.5.1", id="d"), @SpecAssertion(section="2.5.2", id="fa")})
    public void testDefaultNamed() {
        String name = "haddock";
        Bean<Haddock> haddock = this.getUniqueBean(Haddock.class, new Annotation[0]);
        Assert.assertEquals((String)haddock.getName(), (String)name);
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)haddock.getQualifiers(), new Annotation[]{AnyLiteral.INSTANCE, DefaultLiteral.INSTANCE, new NamedLiteral(name)}));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.7", id="a"), @SpecAssertion(section="2.7.1.3", id="aa")})
    public void testStereotypeDefaultsName() {
        Bean<RedSnapper> bean = this.getUniqueBean(RedSnapper.class, new Annotation[0]);
        Assert.assertEquals((String)bean.getName(), (String)"redSnapper");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.5.3", id="a"), @SpecAssertion(section="2", id="e")})
    public void testNamedNotDeclaredByBean() {
        Bean<SeaBass> bean = this.getUniqueBean(SeaBass.class, new Annotation[0]);
        Assert.assertNull((Object)bean.getName());
    }

    @Test
    @SpecAssertion(section="2.5.3", id="a")
    public void testNamedNotDeclaredByStereotype() {
        Bean<Minnow> bean = this.getUniqueBean(Minnow.class, new Annotation[0]);
        Assert.assertNull((Object)bean.getName());
    }
}

