/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.bindingTypes;

import java.lang.annotation.Annotation;
import javax.enterprise.event.Event;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import javax.enterprise.util.TypeLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.AnyLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.bindingTypes.Animal;
import org.jboss.cdi.tck.tests.event.bindingTypes.AnimalAssessment;
import org.jboss.cdi.tck.tests.event.bindingTypes.DiscerningObserver;
import org.jboss.cdi.tck.tests.event.bindingTypes.EventEmitter;
import org.jboss.cdi.tck.tests.event.bindingTypes.NonBindingType;
import org.jboss.cdi.tck.tests.event.bindingTypes.NonRuntimeBindingType;
import org.jboss.cdi.tck.tests.event.bindingTypes.TameAnnotationLiteral;
import org.jboss.cdi.tck.tests.event.bindingTypes.WildAnnotationLiteral;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class EventBindingTypesTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EventBindingTypesTest.class)).build();
    }

    @Test(groups={"events"})
    @SpecAssertion(section="10.1", id="d")
    public void testEventBindingTypeTargetsMethodFieldParameterElementTypes() {
        Animal animal = new Animal();
        this.getCurrentManager().fireEvent((Object)animal, new Annotation[]{new TameAnnotationLiteral()});
        this.getInstanceByType(AnimalAssessment.class, new Annotation[0]).classifyAsTame(animal);
    }

    @Test(groups={"events"})
    @SpecAssertion(section="10.1", id="e")
    public void testEventBindingTypeTargetsFieldParameterElementTypes() {
        Animal animal = new Animal();
        this.getCurrentManager().fireEvent((Object)animal, new Annotation[]{new WildAnnotationLiteral()});
        this.getInstanceByType(AnimalAssessment.class, new Annotation[0]).classifyAsWild(animal);
    }

    @Test(groups={"events"})
    @SpecAssertion(section="10.1", id="f")
    public void testNonRuntimeBindingTypeIsNotAnEventBindingType() {
        DiscerningObserver observer = this.getInstanceByType(DiscerningObserver.class, new Annotation[0]);
        observer.reset();
        EventEmitter emitter = this.getInstanceByType(EventEmitter.class, new Annotation[0]);
        emitter.fireEvent();
        assert (observer.getNumTimesAnyBindingTypeEventObserved() == 1);
        assert (observer.getNumTimesNonRuntimeBindingTypeObserved() == 1);
        emitter.fireEventWithNonRuntimeBindingType();
        assert (observer.getNumTimesAnyBindingTypeEventObserved() == 2);
        assert (observer.getNumTimesNonRuntimeBindingTypeObserved() == 2);
    }

    @Test(groups={"events"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="10.1", id="f")
    public void testFireEventWithNonRuntimeBindingTypeFails() {
        this.getCurrentManager().fireEvent((Object)new Animal(), new Annotation[]{new AnnotationLiteral<NonRuntimeBindingType>(){}});
    }

    @Test(groups={"events"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="10.1", id="g")
    public void testFireEventWithNonBindingAnnotationsFails() {
        this.getCurrentManager().fireEvent((Object)new Animal(), new Annotation[]{new AnnotationLiteral<NonBindingType>(){}});
    }

    @Test(groups={"events"})
    @SpecAssertion(section="10.1", id="i")
    public void testEventAlwaysHasAnyBinding() {
        Bean<Event<Animal>> animalEventBean = this.getUniqueBean(new TypeLiteral<Event<Animal>>(){}, new WildAnnotationLiteral());
        assert (animalEventBean.getQualifiers().contains(AnyLiteral.INSTANCE));
        Bean<Event<Animal>> tameAnimalEventBean = this.getUniqueBean(new TypeLiteral<Event<Animal>>(){}, new TameAnnotationLiteral());
        assert (tameAnimalEventBean.getQualifiers().contains(AnyLiteral.INSTANCE));
        Bean<Event<Animal>> wildAnimalEventBean = this.getUniqueBean(new TypeLiteral<Event<Animal>>(){}, new WildAnnotationLiteral());
        assert (wildAnimalEventBean.getQualifiers().contains(AnyLiteral.INSTANCE));
    }
}

