/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.extension;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.AnyLiteral;
import org.jboss.cdi.tck.tests.event.observer.extension.Angry;
import org.jboss.cdi.tck.tests.event.observer.extension.Giraffe;
import org.jboss.cdi.tck.tests.event.observer.extension.GiraffeObserver;
import org.jboss.cdi.tck.tests.event.observer.extension.Nubian;
import org.jboss.cdi.tck.tests.event.observer.extension.ObserverExtension;
import org.jboss.cdi.tck.tests.event.observer.extension.Tall;
import org.testng.Assert;

public abstract class AbstractObserverNotificationTest
extends AbstractTest {
    @Inject
    private ObserverExtension extension;

    protected abstract void fireEvent(Giraffe var1, Annotation ... var2);

    protected void testNoQualifierInternal() {
        this.reset();
        Giraffe payload = new Giraffe();
        this.fireEvent(payload, new Annotation[0]);
        this.verifyObserversNotNotified(this.extension.getFiveMeterTallGiraffeObserver(), this.extension.getSixMeterTallAngryGiraffeObserver(), this.extension.getAngryNubianGiraffeObserver());
        this.verifyObserversNotified(payload, this.toSet(new Annotation[0]), this.extension.getAnyGiraffeObserver());
    }

    protected void testSingleQualifierInternal() {
        this.reset();
        Giraffe payload = new Giraffe();
        Tall.Literal qualifier = Tall.Literal.FIVE_METERS;
        this.fireEvent(payload, qualifier);
        this.verifyObserversNotNotified(this.extension.getSixMeterTallAngryGiraffeObserver(), this.extension.getAngryNubianGiraffeObserver());
        this.verifyObserversNotified(payload, this.toSet(qualifier), this.extension.getAnyGiraffeObserver(), this.extension.getFiveMeterTallGiraffeObserver());
    }

    protected void testMultipleQualifiersInternal() {
        this.reset();
        Giraffe payload = new Giraffe();
        Set<Annotation> qualifiers = this.toSet(Tall.Literal.FIVE_METERS, new Angry.Literal(), new Nubian.Literal());
        this.fireEvent(payload, qualifiers.toArray(new Annotation[0]));
        this.verifyObserversNotNotified(this.extension.getSixMeterTallAngryGiraffeObserver());
        this.verifyObserversNotified(payload, qualifiers, this.extension.getAnyGiraffeObserver(), this.extension.getFiveMeterTallGiraffeObserver(), this.extension.getAngryNubianGiraffeObserver());
    }

    private void reset() {
        this.extension.getAnyGiraffeObserver().reset();
        this.extension.getFiveMeterTallGiraffeObserver().reset();
        this.extension.getSixMeterTallAngryGiraffeObserver().reset();
        this.extension.getAngryNubianGiraffeObserver().reset();
    }

    private void verifyObserversNotified(Giraffe payload, Set<Annotation> qualifiers, GiraffeObserver ... observers) {
        Set<Annotation> expectedQualifiers = this.processQualifiers(qualifiers);
        for (GiraffeObserver observer : observers) {
            Assert.assertFalse((boolean)observer.isLegacyNotifyCalled());
            Assert.assertEquals((Object)payload, (Object)observer.getReceivedPayload());
            Assert.assertEquals(expectedQualifiers, observer.getReceivedQualifiers());
        }
    }

    private void verifyObserversNotNotified(GiraffeObserver ... observers) {
        for (GiraffeObserver observer : observers) {
            Assert.assertFalse((boolean)observer.isLegacyNotifyCalled());
            Assert.assertNull((Object)observer.getReceivedPayload());
            Assert.assertNull(observer.getReceivedQualifiers());
        }
    }

    private Set<Annotation> toSet(Annotation ... annotations) {
        return new HashSet<Annotation>(Arrays.asList(annotations));
    }

    protected Set<Annotation> processQualifiers(Set<Annotation> qualifiers) {
        qualifiers.add((Annotation)AnyLiteral.INSTANCE);
        return qualifiers;
    }
}

