/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.method;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.observer.method.ConditionalEvent;
import org.jboss.cdi.tck.tests.event.observer.method.DisobedientDog;
import org.jboss.cdi.tck.tests.event.observer.method.IntegerObserver;
import org.jboss.cdi.tck.tests.event.observer.method.LargeDog;
import org.jboss.cdi.tck.tests.event.observer.method.ShowDog;
import org.jboss.cdi.tck.tests.event.observer.method.SmallDog;
import org.jboss.cdi.tck.tests.event.observer.method.StockPrice;
import org.jboss.cdi.tck.tests.event.observer.method.StockWatcher;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class ObserverMethodTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ObserverMethodTest.class)).build();
    }

    @Test(groups={"events"})
    @SpecAssertion(section="11.1.3", id="b")
    public void testGetBeanClassOnObserverMethod() {
        Set observers = this.getCurrentManager().resolveObserverMethods((Object)new StockPrice(), new Annotation[0]);
        Assert.assertEquals((int)observers.size(), (int)1);
        ObserverMethod observerMethod = (ObserverMethod)observers.iterator().next();
        Assert.assertEquals((Object)observerMethod.getBeanClass(), StockWatcher.class);
    }

    @Test(groups={"events"})
    @SpecAssertion(section="11.1.3", id="c")
    public void testGetObservedTypeOnObserverMethod() {
        Set observers = this.getCurrentManager().resolveObserverMethods((Object)new StockPrice(), new Annotation[0]);
        Assert.assertEquals((int)observers.size(), (int)1);
        ObserverMethod observerMethod = (ObserverMethod)observers.iterator().next();
        Assert.assertEquals((Object)observerMethod.getObservedType(), StockPrice.class);
    }

    @Test(groups={"events"})
    @SpecAssertion(section="11.1.3", id="c")
    public void testGetObservedQualifiersOnObserverMethod() {
        Set observers = this.getCurrentManager().resolveObserverMethods((Object)new StockPrice(), new Annotation[0]);
        Assert.assertEquals((int)observers.size(), (int)1);
        ObserverMethod observerMethod = (ObserverMethod)observers.iterator().next();
        Assert.assertTrue((boolean)observerMethod.getObservedQualifiers().isEmpty());
    }

    @Test(groups={"events"})
    @SpecAssertion(section="11.1.3", id="d")
    public void testGetNotifyOnObserverMethod() {
        Set observers = this.getCurrentManager().resolveObserverMethods((Object)new StockPrice(), new Annotation[0]);
        Assert.assertEquals((int)observers.size(), (int)1);
        Assert.assertEquals((Object)((ObserverMethod)observers.iterator().next()).getReception(), (Object)Reception.ALWAYS);
        Set conditionalObservers = this.getCurrentManager().resolveObserverMethods((Object)new ConditionalEvent(), new Annotation[0]);
        Assert.assertFalse((boolean)conditionalObservers.isEmpty());
        Assert.assertEquals((Object)((ObserverMethod)conditionalObservers.iterator().next()).getReception(), (Object)Reception.IF_EXISTS);
    }

    @Test(groups={"events"})
    @SpecAssertion(section="11.1.3", id="e")
    public void testGetTransactionPhaseOnObserverMethod() {
        Assert.assertEquals((Object)((ObserverMethod)this.getCurrentManager().resolveObserverMethods((Object)new StockPrice(), new Annotation[0]).iterator().next()).getTransactionPhase(), (Object)TransactionPhase.IN_PROGRESS);
        Assert.assertEquals((Object)((ObserverMethod)this.getCurrentManager().resolveObserverMethods((Object)new DisobedientDog(), new Annotation[0]).iterator().next()).getTransactionPhase(), (Object)TransactionPhase.BEFORE_COMPLETION);
        Assert.assertEquals((Object)((ObserverMethod)this.getCurrentManager().resolveObserverMethods((Object)new ShowDog(), new Annotation[0]).iterator().next()).getTransactionPhase(), (Object)TransactionPhase.AFTER_COMPLETION);
        Assert.assertEquals((Object)((ObserverMethod)this.getCurrentManager().resolveObserverMethods((Object)new SmallDog(), new Annotation[0]).iterator().next()).getTransactionPhase(), (Object)TransactionPhase.AFTER_FAILURE);
        Assert.assertEquals((Object)((ObserverMethod)this.getCurrentManager().resolveObserverMethods((Object)new LargeDog(), new Annotation[0]).iterator().next()).getTransactionPhase(), (Object)TransactionPhase.AFTER_SUCCESS);
    }

    @Test(groups={"events"})
    @SpecAssertion(section="11.1.3", id="ga")
    public void testInstanceOfBeanForEveryEnabledObserverMethod() {
        Assert.assertFalse((boolean)this.getCurrentManager().resolveObserverMethods((Object)new StockPrice(), new Annotation[0]).isEmpty());
        Assert.assertFalse((boolean)this.getCurrentManager().resolveObserverMethods((Object)new DisobedientDog(), new Annotation[0]).isEmpty());
        Assert.assertFalse((boolean)this.getCurrentManager().resolveObserverMethods((Object)new ShowDog(), new Annotation[0]).isEmpty());
        Assert.assertFalse((boolean)this.getCurrentManager().resolveObserverMethods((Object)new SmallDog(), new Annotation[0]).isEmpty());
        Assert.assertFalse((boolean)this.getCurrentManager().resolveObserverMethods((Object)new LargeDog(), new Annotation[0]).isEmpty());
    }

    @Test(groups={"events"})
    @SpecAssertion(section="11.1.3", id="f")
    public void testNotifyOnObserverMethod() {
        Integer event = 1;
        Set observerMethods = this.getCurrentManager().resolveObserverMethods((Object)event, new Annotation[0]);
        Assert.assertEquals((int)observerMethods.size(), (int)1);
        ((ObserverMethod)observerMethods.iterator().next()).notify((Object)event);
        Assert.assertTrue((boolean)IntegerObserver.wasNotified);
    }
}

