/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.select;

import java.lang.annotation.Annotation;
import javax.enterprise.util.AnnotationLiteral;
import javax.enterprise.util.TypeLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.select.AlarmSystem;
import org.jboss.cdi.tck.tests.event.select.BreakInEvent;
import org.jboss.cdi.tck.tests.event.select.NotABindingType;
import org.jboss.cdi.tck.tests.event.select.SecurityEvent;
import org.jboss.cdi.tck.tests.event.select.SecurityEvent_Illegal;
import org.jboss.cdi.tck.tests.event.select.SecuritySensor;
import org.jboss.cdi.tck.tests.event.select.SystemTest;
import org.jboss.cdi.tck.tests.event.select.Violent;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class SelectEventTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SelectEventTest.class)).build();
    }

    @Test(groups={"events"})
    @SpecAssertion(section="10.3.1", id="eaa")
    public void testEventSelectReturnsEventOfSameType() {
        AlarmSystem alarm = this.getInstanceByType(AlarmSystem.class, new Annotation[0]);
        alarm.reset();
        SecuritySensor sensor = this.getInstanceByType(SecuritySensor.class, new Annotation[0]);
        sensor.securityEvent.fire((Object)new SecurityEvent());
        assert (alarm.getNumSecurityEvents() == 1);
        assert (alarm.getNumSystemTests() == 0);
        assert (alarm.getNumBreakIns() == 0);
        assert (alarm.getNumViolentBreakIns() == 0);
        sensor.securityEvent.select(new Annotation[]{new AnnotationLiteral<SystemTest>(){}}).fire((Object)new SecurityEvent());
        assert (alarm.getNumSecurityEvents() == 2);
        assert (alarm.getNumSystemTests() == 1);
        assert (alarm.getNumBreakIns() == 0);
        assert (alarm.getNumViolentBreakIns() == 0);
        sensor.securityEvent.select(BreakInEvent.class, new Annotation[0]).fire((Object)new BreakInEvent());
        assert (alarm.getNumSecurityEvents() == 3);
        assert (alarm.getNumSystemTests() == 1);
        assert (alarm.getNumBreakIns() == 1);
        assert (alarm.getNumViolentBreakIns() == 0);
        sensor.securityEvent.select(BreakInEvent.class, new Annotation[]{new AnnotationLiteral<Violent>(){}}).fire((Object)new BreakInEvent());
        assert (alarm.getNumSecurityEvents() == 4);
        assert (alarm.getNumSystemTests() == 1);
        assert (alarm.getNumBreakIns() == 2);
        assert (alarm.getNumViolentBreakIns() == 1);
    }

    @Test(groups={"events"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="10.3.1", id="eab")
    public <T> void testEventSelectThrowsExceptionIfEventTypeHasTypeVariable() {
        SecuritySensor sensor = this.getInstanceByType(SecuritySensor.class, new Annotation[0]);
        sensor.securityEvent.select(new TypeLiteral<SecurityEvent_Illegal<T>>(){}, new Annotation[0]);
    }

    @Test(groups={"events"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="10.3.1", id="eba")
    public void testEventSelectThrowsExceptionForDuplicateBindingType() {
        SecuritySensor sensor = this.getInstanceByType(SecuritySensor.class, new Annotation[0]);
        sensor.securityEvent.select(new Annotation[]{new AnnotationLiteral<SystemTest>(){}, new AnnotationLiteral<SystemTest>(){}});
    }

    @Test(groups={"events"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="10.3.1", id="eba")
    public void testEventSelectWithSubtypeThrowsExceptionForDuplicateBindingType() {
        SecuritySensor sensor = this.getInstanceByType(SecuritySensor.class, new Annotation[0]);
        sensor.securityEvent.select(BreakInEvent.class, new Annotation[]{new AnnotationLiteral<Violent>(){}, new AnnotationLiteral<Violent>(){}});
    }

    @Test(groups={"events"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="10.3.1", id="ec")
    public void testEventSelectThrowsExceptionIfAnnotationIsNotBindingType() {
        SecuritySensor sensor = this.getInstanceByType(SecuritySensor.class, new Annotation[0]);
        sensor.securityEvent.select(new Annotation[]{new AnnotationLiteral<NotABindingType>(){}});
    }

    @Test(groups={"events"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="10.3.1", id="ec")
    public void testEventSelectWithSubtypeThrowsExceptionIfAnnotationIsNotBindingType() {
        SecuritySensor sensor = this.getInstanceByType(SecuritySensor.class, new Annotation[0]);
        sensor.securityEvent.select(BreakInEvent.class, new Annotation[]{new AnnotationLiteral<NotABindingType>(){}});
    }
}

