/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.annotated;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.annotated.AbstractC;
import org.jboss.cdi.tck.tests.extensions.annotated.ClassD;
import org.jboss.cdi.tck.tests.extensions.annotated.DogHouse;
import org.jboss.cdi.tck.tests.extensions.annotated.Felid;
import org.jboss.cdi.tck.tests.extensions.annotated.InterfaceA;
import org.jboss.cdi.tck.tests.extensions.annotated.InterfaceB;
import org.jboss.cdi.tck.tests.extensions.annotated.Tame;
import org.jboss.cdi.tck.tests.extensions.annotated.WildCat;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class AlternativeMetaDataTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AlternativeMetaDataTest.class)).build();
    }

    @Test
    @SpecAssertion(section="11.4", id="c")
    public void testBaseType() {
        AnnotatedType annotatedType = this.getCurrentManager().createAnnotatedType(DogHouse.class);
        assert (annotatedType.getBaseType().equals(DogHouse.class));
    }

    @Test
    @SpecAssertion(section="11.4", id="d")
    public void testTypeClosure() {
        AnnotatedType annotatedType = this.getCurrentManager().createAnnotatedType(ClassD.class);
        assert (annotatedType.getTypeClosure().contains(Object.class));
        assert (annotatedType.getTypeClosure().contains(InterfaceA.class));
        assert (annotatedType.getTypeClosure().contains(InterfaceB.class));
        assert (annotatedType.getTypeClosure().contains(AbstractC.class));
        assert (annotatedType.getTypeClosure().contains(ClassD.class));
    }

    @Test
    @SpecAssertion(section="11.4", id="e")
    public void testGetAnnotation() {
        AnnotatedType annotatedType = this.getCurrentManager().createAnnotatedType(ClassD.class);
        assert (annotatedType.getAnnotation(RequestScoped.class) != null);
        assert (annotatedType.getAnnotation(ApplicationScoped.class) == null);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.4", id="f"), @SpecAssertion(section="11.4", id="ga")})
    public void testGetAnnotations() {
        AnnotatedType annotatedType = this.getCurrentManager().createAnnotatedType(ClassD.class);
        assert (annotatedType.getAnnotations().size() == 2);
        assert (this.annotationSetMatches((Set<? extends Annotation>)annotatedType.getAnnotations(), RequestScoped.class, Tame.class));
        AnnotatedType annotatedWildCatType = this.getCurrentManager().createAnnotatedType(WildCat.class);
        assert (this.annotationSetMatches((Set<? extends Annotation>)annotatedWildCatType.getAnnotations(), RequestScoped.class, Felid.class));
    }

    @Test
    @SpecAssertion(section="11.4", id="g")
    public void testIsAnnotationPresent() {
        AnnotatedType annotatedType = this.getCurrentManager().createAnnotatedType(ClassD.class);
        assert (annotatedType.isAnnotationPresent(RequestScoped.class));
        assert (!annotatedType.isAnnotationPresent(ApplicationScoped.class));
    }

    @Test
    @SpecAssertion(section="11.4", id="aaa")
    public void testConstructors() {
        AnnotatedType annotatedType = this.getCurrentManager().createAnnotatedType(WildCat.class);
        Set constructors = annotatedType.getConstructors();
        Assert.assertEquals((int)constructors.size(), (int)1);
        Class<?>[] constructorParams = ((AnnotatedConstructor)constructors.iterator().next()).getJavaMember().getParameterTypes();
        Assert.assertEquals((int)constructorParams.length, (int)1);
        Assert.assertEquals(constructorParams[0], String.class);
    }

    @Test
    @SpecAssertion(section="11.4", id="aab")
    public void testMethods() {
        AnnotatedType annotatedType = this.getCurrentManager().createAnnotatedType(WildCat.class);
        Set methods = annotatedType.getMethods();
        Object[] names = new String[]{"yowl", "jump", "bite", "getName"};
        Assert.assertEquals((int)methods.size(), (int)4);
        for (AnnotatedMethod method : methods) {
            Assert.assertTrue((boolean)this.arrayContains(names, method.getJavaMember().getName()));
        }
    }

    @Test
    @SpecAssertion(section="11.4", id="aac")
    public void testFields() {
        AnnotatedType annotatedType = this.getCurrentManager().createAnnotatedType(WildCat.class);
        Set fields = annotatedType.getFields();
        Object[] names = new String[]{"age", "name"};
        Assert.assertEquals((int)fields.size(), (int)2);
        for (AnnotatedField field : fields) {
            Assert.assertTrue((boolean)this.arrayContains(names, field.getJavaMember().getName()));
        }
    }

    private boolean arrayContains(Object[] array, Object objectToFind) {
        if (array == null || objectToFind == null) {
            return false;
        }
        for (Object obj : array) {
            if (!obj.equals(objectToFind)) continue;
            return true;
        }
        return false;
    }
}

