/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.beanManager.bean;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.Producer;
import org.jboss.cdi.tck.literals.DefaultLiteral;
import org.jboss.cdi.tck.tests.extensions.beanManager.bean.Hungry;
import org.jboss.cdi.tck.tests.extensions.beanManager.bean.Lion;
import org.jboss.cdi.tck.tests.extensions.beanManager.bean.Office;
import org.jboss.cdi.tck.tests.extensions.beanManager.bean.SerializableOffice;
import org.jboss.cdi.tck.tests.extensions.beanManager.bean.Tiger;
import org.jboss.cdi.tck.tests.extensions.beanManager.bean.VehicleDecorator;
import org.jboss.cdi.tck.tests.extensions.beanManager.bean.Zoo;
import org.jboss.cdi.tck.util.ForwardingBeanAttributes;
import org.testng.Assert;

public class BeanExtension
implements Extension {
    private Bean<Lion> hungryLion;
    private Bean<Tiger> hungryTiger;

    void registerBeans(@Observes AfterBeanDiscovery event, BeanManager manager) {
        AnnotatedType oat = manager.createAnnotatedType(Office.class);
        BeanAttributes oa = manager.createBeanAttributes(oat);
        InjectionTarget oit = manager.createInjectionTarget(oat);
        Bean bean = manager.createBean(oa, Office.class, oit);
        event.addBean(bean);
        AnnotatedType soat = manager.createAnnotatedType(SerializableOffice.class);
        BeanAttributes soa = manager.createBeanAttributes(soat);
        InjectionTarget soit = manager.createInjectionTarget(soat);
        Bean serializableBean = manager.createBean(soa, SerializableOffice.class, soit);
        event.addBean(serializableBean);
        AnnotatedType doat = manager.createAnnotatedType(VehicleDecorator.class);
        BeanAttributes doa = this.addDecoratorStereotype(manager.createBeanAttributes(doat));
        InjectionTarget doit = manager.createInjectionTarget(doat);
        Bean decoratorBean = manager.createBean(doa, VehicleDecorator.class, doit);
        Assert.assertTrue((boolean)(decoratorBean instanceof Decorator));
        event.addBean(decoratorBean);
        Assert.assertNotNull(this.hungryLion);
        event.addBean(this.hungryLion);
        Assert.assertNotNull(this.hungryTiger);
        event.addBean(this.hungryTiger);
    }

    void prepareHungryLion(@Observes ProcessProducer<Zoo, Lion> event, BeanManager manager) {
        AnnotatedType zoo = manager.createAnnotatedType(Zoo.class);
        Assert.assertEquals((int)1, (int)zoo.getFields().size());
        BeanAttributes attributes = this.starveOut(manager.createBeanAttributes((AnnotatedMember)zoo.getFields().iterator().next()));
        Producer producer = event.getProducer();
        this.hungryLion = manager.createBean(attributes, Zoo.class, producer);
    }

    void prepareHungryTiger(@Observes ProcessProducer<Zoo, Tiger> event, BeanManager manager) {
        AnnotatedType zoo = manager.createAnnotatedType(Zoo.class);
        AnnotatedMethod method = null;
        for (AnnotatedMethod _method : zoo.getMethods()) {
            if (!_method.getBaseType().equals(Tiger.class)) continue;
            method = _method;
        }
        Assert.assertNotNull(method);
        BeanAttributes attributes = this.starveOut(manager.createBeanAttributes(method));
        Producer producer = event.getProducer();
        this.hungryTiger = manager.createBean(attributes, Zoo.class, producer);
    }

    private <T> BeanAttributes<T> starveOut(final BeanAttributes<T> attributes) {
        return new ForwardingBeanAttributes<T>(){

            @Override
            public Set<Annotation> getQualifiers() {
                HashSet<Hungry.Literal> qualifiers = new HashSet<Hungry.Literal>(attributes.getQualifiers());
                qualifiers.add(Hungry.Literal.INSTANCE);
                qualifiers.remove(DefaultLiteral.INSTANCE);
                return Collections.unmodifiableSet(qualifiers);
            }

            @Override
            protected BeanAttributes<T> attributes() {
                return attributes;
            }
        };
    }

    private <T> BeanAttributes<T> addDecoratorStereotype(final BeanAttributes<T> attributes) {
        return new ForwardingBeanAttributes<T>(){

            @Override
            protected BeanAttributes<T> attributes() {
                return attributes;
            }

            @Override
            public Set<Class<? extends Annotation>> getStereotypes() {
                return Collections.singleton(javax.decorator.Decorator.class);
            }
        };
    }
}

