/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.beanManager.producer;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Producer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.beanManager.producer.AnotherFactory;
import org.jboss.cdi.tck.tests.extensions.beanManager.producer.Factory;
import org.jboss.cdi.tck.tests.extensions.beanManager.producer.SpaceSuit;
import org.jboss.cdi.tck.tests.extensions.beanManager.producer.Toy;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class SyntheticProducerTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SyntheticProducerTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.3.21", id="b")})
    public void testStaticProducerField() {
        AnnotatedField field = (AnnotatedField)this.getAnnotatedMember(Factory.class, "WOODY");
        Producer producer = (Producer)this.cast(this.getCurrentManager().createProducer(field, null));
        Assert.assertNotNull((Object)producer);
        Assert.assertTrue((boolean)producer.getInjectionPoints().isEmpty());
        Toy woody = (Toy)producer.produce(this.getCurrentManager().createCreationalContext(null));
        Assert.assertEquals((String)"Woody", (String)woody.getName());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.3.21", id="b")})
    public void testNonStaticProducerField() {
        AnnotatedField field = (AnnotatedField)this.getAnnotatedMember(AnotherFactory.class, "jessie");
        Bean declaringBean = (Bean)this.cast(this.getCurrentManager().resolve(this.getCurrentManager().getBeans(AnotherFactory.class, new Annotation[0])));
        Producer producer = (Producer)this.cast(this.getCurrentManager().createProducer(field, declaringBean));
        Assert.assertNotNull((Object)producer);
        Assert.assertTrue((boolean)producer.getInjectionPoints().isEmpty());
        Toy jessie = (Toy)producer.produce(this.getCurrentManager().createCreationalContext(null));
        Assert.assertEquals((String)"Jessie", (String)jessie.getName());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.3.21", id="a")})
    public void testStaticProducerMethod() {
        AnnotatedMethod method = (AnnotatedMethod)this.getAnnotatedMember(Factory.class, "getBuzz");
        Producer producer = (Producer)this.cast(this.getCurrentManager().createProducer(method, null));
        Assert.assertNotNull((Object)producer);
        this.validateInjectionPoints(producer.getInjectionPoints());
        Toy buzz = (Toy)producer.produce(this.getCurrentManager().createCreationalContext(null));
        Assert.assertEquals((String)"Buzz Lightyear", (String)buzz.getName());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.3.21", id="a")})
    public void testNonStaticProducerMethod() {
        AnnotatedMethod method = (AnnotatedMethod)this.getAnnotatedMember(AnotherFactory.class, "getRex");
        Bean declaringBean = (Bean)this.cast(this.getCurrentManager().resolve(this.getCurrentManager().getBeans(AnotherFactory.class, new Annotation[0])));
        Producer producer = (Producer)this.cast(this.getCurrentManager().createProducer(method, declaringBean));
        Assert.assertNotNull((Object)producer);
        this.validateInjectionPoints(producer.getInjectionPoints());
        Toy rex = (Toy)producer.produce(this.getCurrentManager().createCreationalContext(null));
        Assert.assertEquals((String)"Rex", (String)rex.getName());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertions(value={@SpecAssertion(section="11.3.21", id="c")})
    public void testInvalidProducerMethod1() {
        AnnotatedMethod method = (AnnotatedMethod)this.getAnnotatedMember(Factory.class, "invalidProducerMethod1");
        this.getCurrentManager().createProducer(method, null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertions(value={@SpecAssertion(section="11.3.21", id="c")})
    public void testInvalidProducerMethod2() {
        AnnotatedMethod method = (AnnotatedMethod)this.getAnnotatedMember(Factory.class, "invalidProducerMethod2");
        this.getCurrentManager().createProducer(method, null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertions(value={@SpecAssertion(section="11.3.21", id="d")})
    public void testInvalidProducerField1() {
        AnnotatedField field = (AnnotatedField)this.getAnnotatedMember(Factory.class, "INVALID_FIELD1");
        this.getCurrentManager().createProducer(field, null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertions(value={@SpecAssertion(section="11.3.21", id="d")})
    public void testInvalidProducerField2() {
        AnnotatedField field = (AnnotatedField)this.getAnnotatedMember(Factory.class, "INVALID_FIELD2");
        this.getCurrentManager().createProducer(field, null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertions(value={@SpecAssertion(section="11.3.21", id="d")})
    public void testInvalidProducerField3() {
        AnnotatedField field = (AnnotatedField)this.getAnnotatedMember(Factory.class, "INVALID_FIELD3");
        this.getCurrentManager().createProducer(field, null);
    }

    private <X, A extends AnnotatedMember<? super X>> A getAnnotatedMember(Class<X> javaClass, String memberName) {
        AnnotatedType type = this.getCurrentManager().createAnnotatedType(javaClass);
        for (AnnotatedField field : type.getFields()) {
            if (!field.getJavaMember().getName().equals(memberName)) continue;
            return (A)field;
        }
        for (AnnotatedMethod method : type.getMethods()) {
            if (!method.getJavaMember().getName().equals(memberName)) continue;
            return (A)method;
        }
        throw new IllegalArgumentException("Member " + memberName + " not found on " + javaClass);
    }

    private void validateInjectionPoints(Set<InjectionPoint> injectionPoints) {
        Assert.assertEquals((int)2, (int)injectionPoints.size());
        for (InjectionPoint ip : injectionPoints) {
            AnnotatedParameter parameter = (AnnotatedParameter)this.cast(ip.getAnnotated());
            if (parameter.getPosition() == 0) {
                Assert.assertEquals(BeanManager.class, (Object)parameter.getBaseType());
            } else if (parameter.getPosition() == 1) {
                Type baseType = parameter.getBaseType();
                if (baseType instanceof ParameterizedType && ((ParameterizedType)baseType).getRawType() instanceof Class) {
                    Assert.assertEquals((Object)((ParameterizedType)baseType).getRawType(), SpaceSuit.class);
                } else {
                    Assert.fail();
                }
            } else {
                Assert.fail((String)("Unexpected injection point " + ip));
            }
            Assert.assertFalse((boolean)ip.isDelegate());
            Assert.assertFalse((boolean)ip.isTransient());
            Assert.assertNull((Object)ip.getBean());
        }
    }

    private <T> T cast(Object obj) {
        return (T)obj;
    }
}

