/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.modules;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessModule;
import org.apache.commons.io.IOUtils;

public class ModuleProcessingExtension
implements Extension {
    private final List<ProcessModuleHolder> modules = new ArrayList<ProcessModuleHolder>();

    public void observe(@Observes ProcessModule event) {
        this.modules.add(new ProcessModuleHolder(event));
    }

    public List<ProcessModuleHolder> getModules() {
        return this.modules;
    }

    public ProcessModuleHolder getFirstModule() {
        if (this.modules == null || this.modules.isEmpty()) {
            return null;
        }
        return this.modules.iterator().next();
    }

    public static class ProcessModuleHolder {
        private final List<Class<?>> interceptors;
        private final List<Class<?>> decorators;
        private final Set<Class<?>> alternatives;
        private final Set<AnnotatedType<?>> annotatedTypes;
        private final Set<Class<?>> classes;
        private final String beansXml;

        public ProcessModuleHolder(ProcessModule event) {
            this.interceptors = new ArrayList(event.getInterceptors());
            this.decorators = new ArrayList(event.getDecorators());
            this.alternatives = new HashSet(event.getAlternatives());
            this.annotatedTypes = new HashSet();
            this.classes = new HashSet();
            Iterator i = event.getAnnotatedTypes();
            while (i.hasNext()) {
                AnnotatedType type = (AnnotatedType)i.next();
                this.annotatedTypes.add(type);
                this.classes.add(type.getJavaClass());
            }
            this.beansXml = this.readBeansXml(event);
        }

        public List<Class<?>> getInterceptors() {
            return this.interceptors;
        }

        public List<Class<?>> getDecorators() {
            return this.decorators;
        }

        public Set<Class<?>> getAlternatives() {
            return this.alternatives;
        }

        public Set<AnnotatedType<?>> getAnnotatedTypes() {
            return this.annotatedTypes;
        }

        public Set<Class<?>> getClasses() {
            return this.classes;
        }

        public String getBeansXml() {
            return this.beansXml;
        }

        private String readBeansXml(ProcessModule event) {
            try {
                return IOUtils.toString((InputStream)event.getBeansXml());
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

