/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.inheritance.generics;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.util.TypeLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.inheritance.generics.Baz;
import org.jboss.cdi.tck.tests.inheritance.generics.Foo;
import org.jboss.cdi.tck.tests.inheritance.generics.Qux;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class MemberLevelInheritanceTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(MemberLevelInheritanceTest.class)).build();
    }

    @Test
    @SpecAssertion(section="4.2", id="f")
    public void testInjectionPointDefinition() throws Exception {
        Bean<Foo> fooBean = this.getUniqueBean(Foo.class, new Annotation[0]);
        Set injectionPoints = fooBean.getInjectionPoints();
        Assert.assertEquals((int)injectionPoints.size(), (int)4);
        for (InjectionPoint injectionPoint : injectionPoints) {
            if ("baz".equals(injectionPoint.getMember().getName())) {
                Assert.assertEquals((Object)injectionPoint.getType(), (Object)new TypeLiteral<Baz<String>>(){}.getType());
                continue;
            }
            if ("t1".equals(injectionPoint.getMember().getName())) {
                Assert.assertEquals((Object)injectionPoint.getType(), String.class);
                continue;
            }
            if ("t2BazList".equals(injectionPoint.getMember().getName())) {
                Assert.assertEquals((Object)injectionPoint.getType(), (Object)new TypeLiteral<Baz<List<Qux>>>(){}.getType());
                continue;
            }
            if ("setT1Array".equals(injectionPoint.getMember().getName())) {
                Assert.assertEquals((Object)injectionPoint.getType(), String[].class);
                continue;
            }
            Assert.fail((String)"Unexpected injection point");
        }
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="4.2", id="f")
    public void testInjectionPoint(Foo foo) throws Exception {
        Assert.assertNotNull((Object)foo);
        Assert.assertNotNull(foo.getBaz());
        Assert.assertNotNull(foo.getT1Array());
        Assert.assertNotNull(foo.getT2BazList());
    }

    @Test
    @SpecAssertion(section="4.2", id="g")
    public void testObserverResolution() throws Exception {
        Set observerMethods = this.getCurrentManager().resolveObserverMethods((Object)new Qux(null), new Annotation[0]);
        Assert.assertEquals((int)observerMethods.size(), (int)1);
        ObserverMethod observerMethod = (ObserverMethod)observerMethods.iterator().next();
        Assert.assertEquals((Object)observerMethod.getBeanClass(), Foo.class);
        Assert.assertEquals((Object)observerMethod.getObservedType(), (Object)new TypeLiteral<Baz<String>>(){}.getType());
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="4.2", id="g")
    public void testObserver(Foo foo) throws Exception {
        Assert.assertNotNull((Object)foo);
        this.getCurrentManager().fireEvent((Object)new Qux(null), new Annotation[0]);
        Assert.assertNotNull(foo.getT1BazEvent());
        Assert.assertNotNull(foo.getT1ObserverInjectionPoint());
    }
}

