/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.interceptors.definition.enterprise.jms;

import javax.annotation.Resource;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;

public class SimpleMessageProducer {
    @Resource(mappedName="java:/ConnectionFactory")
    private static ConnectionFactory connectionFactory;
    @Resource(mappedName="java:/queue/test")
    private static Queue queue;
    @Resource(mappedName="java:/topic/test")
    private static Topic topic;

    public void sendQueueMessage() {
        Connection connection = null;
        Session session = null;
        MessageProducer messageProducer = null;
        TextMessage message = null;
        try {
            connection = connectionFactory.createConnection();
            session = connection.createSession(false, 1);
            messageProducer = session.createProducer((Destination)queue);
            message = session.createTextMessage();
            message.setText(SimpleMessageProducer.class.getName());
            messageProducer.send((Message)message);
        }
        catch (JMSException e) {
            throw new RuntimeException("Cannot send message");
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {}
            }
        }
    }

    public void sendTopicMessage() {
        Connection connection = null;
        Session session = null;
        MessageProducer messageProducer = null;
        TextMessage message = null;
        try {
            connection = connectionFactory.createConnection();
            session = connection.createSession(false, 1);
            messageProducer = session.createProducer((Destination)topic);
            message = session.createTextMessage();
            message.setText(SimpleMessageProducer.class.getName());
            messageProducer.send((Message)message);
        }
        catch (JMSException e) {
            throw new RuntimeException("Cannot send message");
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {}
            }
        }
    }
}

