/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution.enterprise;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution.enterprise.BallBindingLiteral;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution.enterprise.BasketBindingLiteral;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution.enterprise.ComplicatedInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution.enterprise.ComplicatedLifecycleInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution.enterprise.LoggedBinding;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution.enterprise.MessageBinding;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution.enterprise.MessageService;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution.enterprise.MonitorService;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution.enterprise.PingBinding;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution.enterprise.PongBinding;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution.enterprise.RemoteMessageService;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.resolution.enterprise.TransactionalBinding;
import org.jboss.cdi.tck.util.Timer;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"javaee-full"})
@SpecVersion(spec="cdi", version="20091101")
public class EnterpriseInterceptorBindingResolutionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EnterpriseInterceptorBindingResolutionTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createInterceptors().clazz(new String[]{ComplicatedInterceptor.class.getName(), ComplicatedLifecycleInterceptor.class.getName()}).up())).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="9.5", id="ba")
    public void testBusinessMethodInterceptorBindings(MessageService messageService, MonitorService monitorService) {
        Assert.assertEquals((int)this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{new AnnotationLiteral<MessageBinding>(){}, new AnnotationLiteral<LoggedBinding>(){}, new AnnotationLiteral<TransactionalBinding>(){}, new AnnotationLiteral<PingBinding>(){}, new AnnotationLiteral<PongBinding>(){}, new BallBindingLiteral(true, true)}).size(), (int)1);
        Assert.assertNotNull((Object)messageService);
        ComplicatedInterceptor.reset();
        messageService.ping();
        Assert.assertTrue((boolean)ComplicatedInterceptor.intercepted);
        Assert.assertNotNull((Object)monitorService);
        ComplicatedInterceptor.reset();
        monitorService.ping();
        Assert.assertFalse((boolean)ComplicatedInterceptor.intercepted);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="9.5", id="bb")
    public void testTimeoutMethodInterceptorBindings(MessageService messageService) throws Exception {
        Assert.assertNotNull((Object)messageService);
        ComplicatedInterceptor.reset();
        messageService.start();
        Timer.StopCondition condition = new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return ComplicatedInterceptor.intercepted;
            }
        };
        Timer timer = new Timer().addStopCondition(condition).start();
        Assert.assertTrue((timer.isStopConditionsSatisfiedBeforeTimeout() || condition.isSatisfied() ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertion(section="9.5", id="a")
    public void testLifecycleInterceptorBindings() throws Exception {
        Assert.assertEquals((int)this.getCurrentManager().resolveInterceptors(InterceptionType.POST_CONSTRUCT, new Annotation[]{new AnnotationLiteral<MessageBinding>(){}, new AnnotationLiteral<LoggedBinding>(){}, new AnnotationLiteral<TransactionalBinding>(){}, new BasketBindingLiteral(true, true)}).size(), (int)1);
        Assert.assertEquals((int)this.getCurrentManager().resolveInterceptors(InterceptionType.PRE_DESTROY, new Annotation[]{new AnnotationLiteral<MessageBinding>(){}, new AnnotationLiteral<LoggedBinding>(){}, new AnnotationLiteral<TransactionalBinding>(){}, new BasketBindingLiteral(true, true)}).size(), (int)1);
        ComplicatedLifecycleInterceptor.reset();
        Bean<RemoteMessageService> bean = this.getUniqueBean(RemoteMessageService.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        RemoteMessageService remoteMessageService = (RemoteMessageService)bean.create(ctx);
        remoteMessageService.ping();
        bean.destroy((Object)remoteMessageService, ctx);
        Assert.assertTrue((boolean)ComplicatedLifecycleInterceptor.postConstructCalled);
        Assert.assertTrue((boolean)ComplicatedLifecycleInterceptor.preDestroyCalled);
    }
}

