/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.interceptors.definition.lifecycle;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.interceptors.definition.lifecycle.DestructionInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.lifecycle.Missile;
import org.jboss.cdi.tck.tests.interceptors.definition.lifecycle.MissileInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.lifecycle.Rocket;
import org.jboss.cdi.tck.tests.interceptors.definition.lifecycle.Weapon;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class LifecycleInterceptorDefinitionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(LifecycleInterceptorDefinitionTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createInterceptors().clazz(new String[]{MissileInterceptor.class.getName(), DestructionInterceptor.class.getName()}).up())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="9.3", id="a"), @SpecAssertion(section="9.5", id="a")})
    public void testLifecycleInterception() {
        ActionSequence.reset();
        Bean<Missile> bean = this.getUniqueBean(Missile.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        Missile missile = (Missile)bean.create(ctx);
        missile.fire();
        bean.destroy((Object)missile, ctx);
        Assert.assertEquals((int)ActionSequence.getSequenceSize("postConstruct"), (int)1);
        Assert.assertEquals((String)ActionSequence.getSequenceData("postConstruct").get(0), (String)MissileInterceptor.class.getName());
        Assert.assertEquals((int)ActionSequence.getSequenceSize("preDestroy"), (int)1);
        Assert.assertEquals((String)ActionSequence.getSequenceData("preDestroy").get(0), (String)MissileInterceptor.class.getName());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="9.5", id="a")})
    public void tesMultipleLifecycleInterceptors() {
        ActionSequence.reset();
        Bean<Rocket> bean = this.getUniqueBean(Rocket.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        Rocket rocket = (Rocket)bean.create(ctx);
        rocket.fire();
        bean.destroy((Object)rocket, ctx);
        List<String> postConstruct = ActionSequence.getSequenceData("postConstruct");
        Assert.assertEquals((int)postConstruct.size(), (int)4);
        Assert.assertEquals((String)postConstruct.get(0), (String)MissileInterceptor.class.getName());
        Assert.assertEquals((String)postConstruct.get(1), (String)DestructionInterceptor.class.getName());
        Assert.assertEquals((String)postConstruct.get(2), (String)Weapon.class.getName());
        Assert.assertEquals((String)postConstruct.get(3), (String)Rocket.class.getName());
        List<String> preDestroy = ActionSequence.getSequenceData("preDestroy");
        Assert.assertEquals((int)preDestroy.size(), (int)4);
        Assert.assertEquals((String)preDestroy.get(0), (String)MissileInterceptor.class.getName());
        Assert.assertEquals((String)preDestroy.get(1), (String)DestructionInterceptor.class.getName());
        Assert.assertEquals((String)preDestroy.get(2), (String)Weapon.class.getName());
        Assert.assertEquals((String)preDestroy.get(3), (String)Rocket.class.getName());
    }
}

