/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.circular;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.circular.Bird;
import org.jboss.cdi.tck.tests.lookup.circular.Car;
import org.jboss.cdi.tck.tests.lookup.circular.DependentSelfConsumingNormalProducer;
import org.jboss.cdi.tck.tests.lookup.circular.Food;
import org.jboss.cdi.tck.tests.lookup.circular.House;
import org.jboss.cdi.tck.tests.lookup.circular.NormalSelfConsumingDependentProducer;
import org.jboss.cdi.tck.tests.lookup.circular.NormalSelfConsumingNormalProducer;
import org.jboss.cdi.tck.tests.lookup.circular.Petrol;
import org.jboss.cdi.tck.tests.lookup.circular.Pig;
import org.jboss.cdi.tck.tests.lookup.circular.Planet;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class CircularDependencyTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(CircularDependencyTest.class)).build();
    }

    @Test
    @SpecAssertion(section="5", id="b")
    public void testCircularInjectionOnTwoNormalBeans() throws Exception {
        Pig pig = this.getInstanceByType(Pig.class, new Annotation[0]);
        Food food = this.getInstanceByType(Food.class, new Annotation[0]);
        assert (pig.getNameOfFood().equals(food.getName()));
        assert (food.getNameOfPig().equals(pig.getName()));
    }

    @Test
    @SpecAssertion(section="5", id="b")
    public void testCircularInjectionOnOneNormalAndOneDependentBean() throws Exception {
        Petrol petrol = this.getInstanceByType(Petrol.class, new Annotation[0]);
        Car car = this.getInstanceByType(Car.class, new Annotation[0]);
        assert (petrol.getNameOfCar().equals(car.getName()));
        assert (car.getNameOfPetrol().equals(petrol.getName()));
    }

    @Test
    @SpecAssertion(section="5", id="b")
    public void testNormalProducerMethodDeclaredOnNormalBeanWhichInjectsProducedBean() throws Exception {
        this.getInstanceByType(NormalSelfConsumingNormalProducer.class, new Annotation[0]).ping();
    }

    @Test
    @SpecAssertion(section="5", id="b")
    public void testNormalProducerMethodDeclaredOnDependentBeanWhichInjectsProducedBean() throws Exception {
        this.getInstanceByType(DependentSelfConsumingNormalProducer.class, new Annotation[0]).ping();
    }

    @Test
    @SpecAssertion(section="5", id="b")
    public void testDependentProducerMethodDeclaredOnNormalBeanWhichInjectsProducedBean() throws Exception {
        this.getInstanceByType(NormalSelfConsumingDependentProducer.class, new Annotation[0]).ping();
    }

    @Test
    @SpecAssertion(section="5", id="b")
    public void testNormalCircularConstructors() throws Exception {
        assert (this.getInstanceByType(Bird.class, new Annotation[0]) != null);
    }

    @Test
    @SpecAssertion(section="5", id="b")
    public void testNormalAndDependentCircularConstructors() throws Exception {
        assert (this.getInstanceByType(Planet.class, new Annotation[0]) != null);
    }

    @Test
    @SpecAssertion(section="5", id="b")
    public void testSelfConsumingConstructorsOnNormalBean() throws Exception {
        assert (this.getInstanceByType(House.class, new Annotation[0]) != null);
    }
}

