/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.dynamic.destroy.normal;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.cdi.tck.tests.lookup.dynamic.destroy.normal.CustomScoped;
import org.testng.Assert;

public class CustomNonAlterableContext
implements Context {
    private final Map<Contextual<?>, Instance> storage = new ConcurrentHashMap();
    private boolean active;

    public Class<? extends Annotation> getScope() {
        return CustomScoped.class;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        T instance = this.get(contextual);
        if (instance == null) {
            this.storage.put(contextual, new Instance(contextual.create(creationalContext), creationalContext));
            instance = this.get(contextual);
        }
        return instance;
    }

    public <T> T get(Contextual<T> contextual) {
        Instance instance = this.storage.get(contextual);
        if (instance != null) {
            return (T)instance.instance;
        }
        return null;
    }

    public boolean isActive() {
        return this.active;
    }

    public void activate() {
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
        for (Contextual<?> contextual : this.storage.keySet()) {
            this.destroy(contextual);
        }
    }

    protected void destroy(Contextual<?> contextual) {
        Assert.assertTrue((boolean)(contextual instanceof Serializable));
        Instance instance = this.storage.remove(contextual);
        if (instance != null) {
            Contextual<?> rawContextual = contextual;
            rawContextual.destroy(instance.instance, instance.ctx);
        }
    }

    private static class Instance {
        private final Object instance;
        private final CreationalContext<?> ctx;

        public Instance(Object instance, CreationalContext<?> ctx) {
            this.instance = instance;
            this.ctx = ctx;
        }
    }
}

