/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.injection;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.injection.DeluxeHenHouse;
import org.jboss.cdi.tck.tests.lookup.injection.MegaPoorHenHouse;
import org.jboss.cdi.tck.tests.lookup.injection.SpiderNest;
import org.jboss.cdi.tck.tests.lookup.injection.WolfPack;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class InjectionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InjectionTest.class)).withWebXml((WebAppDescriptor)((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).createEnvEntry().envEntryName("greeting").envEntryType("java.lang.String").envEntryValue("Hello").up())).build();
    }

    @Test(groups={"injection", "producerMethod"})
    @SpecAssertion(section="5.2.5", id="aa")
    public void testInjectionPerformsBoxingIfNecessary() throws Exception {
        assert (this.getBeans(SpiderNest.class, new Annotation[0]).size() == 1);
        SpiderNest spiderNest = this.getInstanceByType(SpiderNest.class, new Annotation[0]);
        assert (spiderNest.numberOfSpiders != null);
        assert (spiderNest.numberOfSpiders.equals(4));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2.1", id="kc"), @SpecAssertion(section="5.5", id="b"), @SpecAssertion(section="5.5.2", id="ac")})
    public void testInjectionOfNamedBean() {
        WolfPack wolfPack = this.getInstanceByType(WolfPack.class, new Annotation[0]);
        assert (wolfPack.getAlphaWolf() != null);
    }

    @Test(groups={"integration"}, dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="4.2", id="aa"), @SpecAssertion(section="5.5.2", id="bg"), @SpecAssertion(section="5.5.2", id="bh"), @SpecAssertion(section="5.5.2", id="bk"), @SpecAssertion(section="5.5.2", id="bl")})
    public void testInjectionFieldsAndInitializerMethods(DeluxeHenHouse henHouse) throws Exception {
        Assert.assertNotNull((Object)henHouse.fox);
        Assert.assertEquals((String)henHouse.fox.getName(), (String)"gavin");
        Assert.assertTrue((boolean)henHouse.initializerCalledAfterInjectionPointsInit);
        Assert.assertTrue((boolean)henHouse.postConstructCalledAfterInitializers);
    }

    @Test
    @SpecAssertion(section="4.2", id="ac")
    public void testFieldDeclaredInIndirectSuperclassInjected() throws Exception {
        MegaPoorHenHouse henHouse = this.getInstanceByType(MegaPoorHenHouse.class, new Annotation[0]);
        assert (henHouse.fox != null);
        assert (henHouse.fox.getName().equals("gavin"));
    }
}

